/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.cpp.AbstractCppMakefileGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCMakeListsGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppDefaultMakefileGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppMakefileGenerator;
import org.eclipse.papyrusrt.codegen.cpp.profile.facade.RTCppGenerationProperties;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Element;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratableElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Constructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppArtifact;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppEnum;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppNamespace;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Destructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Enumerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.MemberAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.xtumlrt.common.Artifact;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Enumeration;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtModelTranslator;
import org.eclipse.papyrusrt.xtumlrt.util.GeneralUtil;
import org.eclipse.papyrusrt.xtumlrt.util.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;

public class CppCodePattern {
    private UML2xtumlrtModelTranslator translator;
    private File outputFolder;
    private File modelFolder;
    private EObject top;
    private List<FileName> sourceFiles = new ArrayList<FileName>();
    private final Map<Key, ElementList> elementLists = new HashMap<Key, ElementList>();
    private final Map<Key, CppArtifact> artifacts = new HashMap<Key, CppArtifact>();
    private final Map<Key, CppClass> cppClasses = new HashMap<Key, CppClass>();
    private final Map<Key, CppNamespace> cppNamespaces = new HashMap<Key, CppNamespace>();
    private final Map<Key, Variable> variables = new HashMap<Key, Variable>();
    private final Map<Key, CppEnum> cppEnums = new HashMap<Key, CppEnum>();
    private final Map<Key, Enumerator> enumerators = new HashMap<Key, Enumerator>();
    private final Map<Key, Constructor> constructors = new HashMap<Key, Constructor>();
    private final Map<Key, Constructor> copyConstructors = new HashMap<Key, Constructor>();
    private final Map<Key, Destructor> destructors = new HashMap<Key, Destructor>();
    private final List<ElementList> outputs = new ArrayList<ElementList>();

    public CppCodePattern() {
    }

    public CppCodePattern(UML2xtumlrtModelTranslator translator) {
        this.translator = translator;
    }

    public UML2xtumlrtModelTranslator getTranslator() {
        return this.translator;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setModelFolder(File modelFolder) {
        this.modelFolder = modelFolder;
    }

    public void setTop(EObject topCapsule) {
        this.top = topCapsule;
    }

    public void setFilenames(Collection<FileName> filenames) {
        this.sourceFiles.addAll(filenames);
    }

    public boolean markWritable(ElementList elements) {
        if (!this.elementLists.containsValue(elements)) {
            return false;
        }
        this.outputs.add(elements);
        return true;
    }

    public File getControllerAllocations(String topCapsule) {
        File allocationsFile = new File(this.modelFolder, String.valueOf(topCapsule) + ".controllers");
        return allocationsFile.exists() ? allocationsFile : null;
    }

    public ElementList getElementList(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        ElementList elementList = null;
        switch (output) {
            case Deployment: {
                elementList = this.elementLists.get(k);
                if (elementList == null) {
                    elementList = new ElementList(new FileName(String.valueOf(element.getName()) + "Controllers"));
                    this.elementLists.put(k, elementList);
                }
                return elementList;
            }
            case Artifact: {
                elementList = this.elementLists.get(k);
                if (elementList == null) {
                    elementList = new ElementList(new FileName(element.getName()));
                    this.elementLists.put(k, elementList);
                }
                return elementList;
            }
        }
        return this.getElementList(k, element);
    }

    public CppArtifact getWritableCppArtifact(Output output, NamedElement element) {
        CppArtifact artifact = this.getArtifact(output, element);
        HeaderFile header = artifact.getDefinedIn();
        if (header instanceof ElementList) {
            this.markWritable((ElementList)header);
        }
        return artifact;
    }

    public CppClass getWritableCppClass(Output output, NamedElement element) {
        CppClass cls = this.getCppClass(output, element);
        HeaderFile header = cls.getDefinedIn();
        if (header instanceof ElementList) {
            this.markWritable((ElementList)header);
        }
        return cls;
    }

    public CppEnum getWritableCppEnum(Output output, NamedElement element) {
        CppEnum enm = this.getCppEnum(output, element);
        HeaderFile header = enm.getDefinedIn();
        if (header instanceof ElementList) {
            this.markWritable((ElementList)header);
        }
        return enm;
    }

    public CppNamespace getWritableCppNamespace(Output output, NamedElement element) {
        CppNamespace namespace = this.getCppNamespace(output, element);
        HeaderFile header = namespace.getDefinedIn();
        if (header instanceof ElementList) {
            this.markWritable((ElementList)header);
        }
        return namespace;
    }

    public CppClass getCppClass(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        CppClass cls = this.cppClasses.get(k);
        if (cls == null) {
            switch (output) {
                case CapsuleClass: 
                case BasicClass: {
                    cls = new CppClass(this.getName(output, element));
                    ElementList elements = this.getElementList(k, element);
                    elements.addElement(new IUserElement[]{cls});
                    this.applyRTCppGenerationProperties(elements, element);
                    break;
                }
                case ProtocolBaseRole: 
                case ProtocolConjugateRole: {
                    cls = new CppClass(this.getName(output, element));
                    this.getCppNamespace(Output.ProtocolClass, element).addMember((IGeneratableElement)cls);
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppClass for " + output.toString());
                }
            }
            this.cppClasses.put(k, cls);
        }
        return cls;
    }

    public CppNamespace getCppNamespace(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        CppNamespace namespace = this.cppNamespaces.get(k);
        if (namespace == null) {
            switch (output) {
                case ProtocolClass: {
                    namespace = new CppNamespace(this.getName(output, element));
                    ElementList elements = this.getElementList(k, element);
                    elements.addElement(new IUserElement[]{namespace});
                    this.applyRTCppGenerationProperties(elements, element);
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppNamespace for " + output.toString());
                }
            }
            this.cppNamespaces.put(k, namespace);
        }
        return namespace;
    }

    public Constructor getConstructor(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        Constructor ctor = this.constructors.get(k);
        if (ctor == null) {
            switch (output) {
                case CapsuleClass: 
                case BasicClass: 
                case ProtocolBaseRole: 
                case ProtocolConjugateRole: {
                    ctor = new Constructor();
                    this.getCppClass(output, element).addMember(CppClass.Visibility.PUBLIC, ctor);
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a Constructor for " + output.toString());
                }
            }
            this.constructors.put(k, ctor);
        }
        return ctor;
    }

    public Constructor getCopyConstructor(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        Constructor ctor = this.copyConstructors.get(k);
        if (ctor == null) {
            switch (output) {
                case CapsuleClass: 
                case BasicClass: 
                case ProtocolBaseRole: 
                case ProtocolConjugateRole: {
                    ctor = new Constructor();
                    this.getCppClass(output, element).addMember(CppClass.Visibility.PUBLIC, ctor);
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a copy Constructor for " + output.toString());
                }
            }
            this.copyConstructors.put(k, ctor);
        }
        return ctor;
    }

    public Destructor getDestructor(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        Destructor dtor = this.destructors.get(k);
        if (dtor == null) {
            switch (output) {
                case CapsuleClass: 
                case BasicClass: {
                    dtor = new Destructor();
                    this.getCppClass(output, element).addMember(CppClass.Visibility.PUBLIC, dtor);
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a Destructor for " + output.toString());
                }
            }
            this.destructors.put(k, dtor);
        }
        return dtor;
    }

    public Variable getVariable(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        Variable var = this.variables.get(k);
        if (var == null) {
            switch (output) {
                case UMLRTCapsuleClass: {
                    var = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTCapsuleClass.getType().const_(), this.getName(output, element));
                    break;
                }
                case UMLRTTypeDescriptor: {
                    var = new Variable(LinkageSpec.EXTERN, UMLRTRuntime.UMLRTObject.getType().const_(), this.getName(output, element));
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a Variable for " + output.toString());
                }
            }
            this.variables.put(k, var);
        }
        return var;
    }

    public CppEnum getCppEnum(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        CppEnum enm = this.cppEnums.get(k);
        if (enm == null) {
            switch (output) {
                case UserEnum: {
                    enm = new CppEnum(element.getName());
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppEnum for " + output.toString());
                }
            }
            ElementList elements = this.getElementList(k, element);
            elements.addElement(new IUserElement[]{enm});
            enm.setDefinedIn((HeaderFile)elements);
            this.cppEnums.put(k, enm);
        }
        return enm;
    }

    public CppArtifact getArtifact(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        CppArtifact artifact = this.artifacts.get(k);
        if (artifact == null) {
            switch (output) {
                case Artifact: {
                    if (!(element instanceof Artifact)) {
                        throw new RuntimeException("code pattern requires Artifact for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                    }
                    artifact = new CppArtifact(this.getName(output, element));
                    ElementList elements = this.getElementList(k, element);
                    elements.addElement(new IUserElement[]{artifact});
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain an Artifact for " + output.toString());
                }
            }
        }
        return artifact;
    }

    private static Map<String, NamedElement> getSortedSignals(Protocol protocol) {
        RedefinableElement parent = protocol.getRedefines();
        LinkedHashMap<String, NamedElement> elements = parent instanceof Protocol ? CppCodePattern.getSortedSignals((Protocol)parent) : new LinkedHashMap();
        for (NamedElement element : RTSModelLibraryUtils.getUserSignals((Protocol)protocol)) {
            elements.put(element.getName(), element);
        }
        return elements;
    }

    private static Map<String, NamedElement> getSortedPorts(Capsule capsule) {
        RedefinableElement parent = capsule.getRedefines();
        LinkedHashMap<String, NamedElement> elements = parent instanceof Capsule ? CppCodePattern.getSortedPorts((Capsule)parent) : new LinkedHashMap();
        for (Port element : XTUMLRTUtil.getRTPorts((Capsule)capsule)) {
            elements.put(element.getName(), (NamedElement)element);
        }
        return elements;
    }

    private static Map<String, NamedElement> getSortedParts(Capsule capsule) {
        RedefinableElement parent = capsule.getRedefines();
        LinkedHashMap<String, NamedElement> elements = parent instanceof Capsule ? CppCodePattern.getSortedParts((Capsule)parent) : new LinkedHashMap();
        for (CapsulePart element : XTUMLRTUtil.getCapsuleParts((Capsule)capsule)) {
            elements.put(element.getName(), (NamedElement)element);
        }
        return elements;
    }

    public CppEnum getIdEnum(Output output, NamedElement element) {
        Key k = new Key(output, element, null);
        CppEnum enm = this.cppEnums.get(k);
        if (enm == null) {
            Map<String, NamedElement> enumeratorElements = null;
            Output clsKind = null;
            String enumName = null;
            Expression firstLiteral = null;
            switch (output) {
                case SignalId: {
                    CppNamespace namespace = this.getCppNamespace(Output.ProtocolClass, element);
                    enm = new CppEnum((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)namespace, "SignalId", UMLRTRuntime.UMLRTSignal.FIRST_PROTOCOL_SIGNAL_ID());
                    namespace.addMember((IGeneratableElement)enm);
                    enumeratorElements = CppCodePattern.getSortedSignals((Protocol)element);
                    break;
                }
                case PortId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "PortId";
                    enumeratorElements = CppCodePattern.getSortedPorts((Capsule)element);
                    break;
                }
                case PartId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "PartId";
                    enumeratorElements = CppCodePattern.getSortedParts((Capsule)element);
                    break;
                }
                case BorderPortId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "BorderPortId";
                    break;
                }
                case InternalPortId: {
                    clsKind = Output.CapsuleClass;
                    enumName = "InternalPortId";
                    break;
                }
                default: {
                    throw new RuntimeException("code pattern does not contain a CppEnum for " + output.toString());
                }
            }
            if (enm == null) {
                CppClass cls = this.getCppClass(clsKind, element);
                enm = new CppEnum((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)cls, enumName, firstLiteral);
                cls.addMember(CppClass.Visibility.PUBLIC, enm);
            }
            this.cppEnums.put(k, enm);
            if (enumeratorElements != null) {
                for (NamedElement enumeratorElement : enumeratorElements.values()) {
                    this.getEnumerator(output, enumeratorElement, element);
                }
            }
        }
        return enm;
    }

    public Enumerator getEnumerator(Output output, NamedElement element, NamedElement context) {
        Key k = new Key(output, element, context);
        Enumerator enumerator = this.enumerators.get(k);
        if (enumerator == null) {
            switch (output) {
                case SignalId: {
                    if (!(element instanceof Signal)) {
                        throw new RuntimeException("code pattern requires Signal for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                    }
                    if (context instanceof NamedElement) break;
                    throw new RuntimeException("code pattern requires NamedElement as owner for " + output.toString() + " but got " + context.getClass().getCanonicalName());
                }
                case PortId: 
                case BorderPortId: 
                case InternalPortId: 
                case PartId: {
                    if (context instanceof NamedElement) break;
                    throw new RuntimeException("code pattern requires NamedElement as owner for " + output.toString() + " but got " + context.getClass().getCanonicalName());
                }
                default: {
                    throw new RuntimeException("code pattern does not contain an Enumerator for " + output.toString());
                }
            }
            CppEnum enm = this.getIdEnum(output, context);
            enumerator = this.enumerators.get(k);
            if (enumerator == null) {
                enumerator = enm.add(this.getName(output, element));
                this.enumerators.put(k, enumerator);
            }
        }
        return enumerator;
    }

    public Expression getEnumeratorAccess(Output output, NamedElement element, NamedElement context) {
        CppClass cppElement = null;
        switch (output) {
            case SignalId: {
                if (!(element instanceof Signal)) {
                    throw new RuntimeException("code pattern requires Signal for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                }
                Signal signal = (Signal)element;
                if (context == null) {
                    NamedElement owner = XTUMLRTUtil.getOwner((CommonElement)signal);
                    if (owner == null || !(owner instanceof Protocol)) {
                        throw new RuntimeException("code pattern: the owner of signal " + signal.getName() + " is not a protocol");
                    }
                    Protocol protocol = (Protocol)owner;
                    if (RTSModelLibraryUtils.isSystemElement((CommonElement)protocol)) {
                        return UMLRTRuntime.getSystemProtocolSignalAccess((Signal)signal);
                    }
                    context = protocol;
                }
                cppElement = this.getCppNamespace(Output.ProtocolClass, context);
                break;
            }
            case PartId: {
                if (!(element instanceof CapsulePart)) {
                    throw new RuntimeException("code pattern requires Property for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                }
                if (context == null) {
                    NamedElement capsule;
                    CapsulePart part = (CapsulePart)element;
                    context = capsule = XTUMLRTUtil.getOwner((CommonElement)part);
                }
                cppElement = this.getCppClass(Output.CapsuleClass, context);
                break;
            }
            case PortId: 
            case BorderPortId: 
            case InternalPortId: {
                if (!(element instanceof Port)) {
                    throw new RuntimeException("code pattern requires Port for " + output.toString() + " but got " + element.getClass().getCanonicalName());
                }
                if (context == null) {
                    NamedElement capsule;
                    Port port = (Port)element;
                    context = capsule = XTUMLRTUtil.getOwner((CommonElement)port);
                }
                cppElement = this.getCppClass(Output.CapsuleClass, context);
                break;
            }
            default: {
                throw new RuntimeException("no enumerator access expression defined for " + (Object)((Object)output));
            }
        }
        Enumerator enumerator = this.getEnumerator(output, element, context);
        return new MemberAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)cppElement, (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)enumerator);
    }

    public Element getCppElement(NamedElement element) {
        if (RTSModelLibraryUtils.isSystemElement((CommonElement)element)) {
            return UMLRTRuntime.getSystemElement((NamedElement)element);
        }
        if (element instanceof Capsule) {
            return this.getCppClass(Output.CapsuleClass, element);
        }
        if (element instanceof StructuredType) {
            return this.getCppClass(Output.BasicClass, element);
        }
        if (element instanceof Protocol) {
            return this.getCppNamespace(Output.ProtocolClass, element);
        }
        if (element instanceof Enumeration) {
            return this.getCppEnum(Output.UserEnum, element);
        }
        if (element instanceof Artifact) {
            return this.getArtifact(Output.Artifact, element);
        }
        return null;
    }

    private String getName(Output output, NamedElement element) {
        switch (output) {
            case CapsuleClass: {
                return "Capsule_" + element.getName();
            }
            case ProtocolBaseRole: {
                return "Base";
            }
            case ProtocolConjugateRole: {
                return "Conj";
            }
            case SignalId: {
                return "signal_" + element.getName();
            }
            case PortId: {
                return "port_" + element.getName();
            }
            case BorderPortId: {
                return "borderport_" + element.getName();
            }
            case InternalPortId: {
                return "internalport_" + element.getName();
            }
            case PartId: {
                return "part_" + element.getName();
            }
            case UMLRTTypeDescriptor: {
                return "UMLRTType_" + element.getName();
            }
        }
        return element.getName();
    }

    private ElementList getElementList(Key k, NamedElement element) {
        ElementList elementList = this.elementLists.get(k);
        if (elementList == null) {
            switch (k.output) {
                case UMLRTCapsuleClass: {
                    return this.getElementList(Output.CapsuleClass, element);
                }
                case Artifact: {
                    if (!(element instanceof Artifact)) {
                        throw new RuntimeException("code pattern for Artifact requires " + k.output.toString());
                    }
                    Artifact aft = (Artifact)element;
                    String fileName = aft.getFileName();
                    if (fileName.isEmpty()) {
                        if (aft.getName().isEmpty()) {
                            throw new RuntimeException("artifact has no name: " + QualifiedNames.getQualifiedName((EObject)aft, (boolean)true));
                        }
                        fileName = aft.getName();
                    }
                    elementList = new ElementList(new FileName(fileName));
                    break;
                }
                default: {
                    elementList = new ElementList(new FileName(element.getName()));
                }
            }
            this.elementLists.put(k, elementList);
        }
        return elementList;
    }

    public boolean write() {
        String baseFolder = this.outputFolder.getAbsolutePath();
        boolean ret = true;
        for (ElementList output : this.outputs) {
            try (CppWriter out = CppWriter.create((String)baseFolder, (ElementList)output);){
                if (output.write(out)) continue;
                ret = false;
                System.err.println("Failure while writing '" + output.getName().getAbsolutePath() + "' to disk");
            }
        }
        AbstractCppMakefileGenerator gen = new CppMakefileGenerator();
        String makefile = gen.formatFilename(GeneralUtil.getName((EObject)this.top));
        gen.generate(Paths.get(baseFolder, makefile).toString(), this.sourceFiles, this.getMainName());
        new CppDefaultMakefileGenerator().generate(Paths.get(baseFolder, "Makefile").toString(), makefile);
        gen = new CppCMakeListsGenerator();
        makefile = gen.formatFilename(GeneralUtil.getName((EObject)this.top));
        gen.generate(Paths.get(baseFolder, makefile).toString(), this.sourceFiles, this.getMainName());
        return ret;
    }

    public String getMainName() {
        return String.valueOf(GeneralUtil.getName((EObject)this.top)) + "Main";
    }

    private void applyRTCppGenerationProperties(ElementList elements, NamedElement element) {
        Boolean generateHeaderBool = RTCppGenerationProperties.getFileGenerationPropGenerateHeader((CommonElement)element);
        Boolean generateImplemBool = RTCppGenerationProperties.getFileGenerationPropGenerateImplementation((CommonElement)element);
        String headPreface = RTCppGenerationProperties.getCppFileHeaderPreface((CommonElement)element);
        String headEnding = RTCppGenerationProperties.getCppFileHeaderEnding((CommonElement)element);
        String implPreface = RTCppGenerationProperties.getCppFileImplementationPreface((CommonElement)element);
        String implEnding = RTCppGenerationProperties.getCppFileImplementationEnding((CommonElement)element);
        boolean generateHeader = generateHeaderBool == null || generateHeaderBool != false;
        boolean generateImplem = generateImplemBool == null || generateImplemBool != false;
        elements.setWriteDecl(generateHeader);
        elements.setWriteDefn(generateImplem);
        elements.addDeclPrefaceText(headPreface);
        elements.addDeclEndingText(headEnding);
        elements.addDefnPrefaceText(implPreface);
        elements.addDefnEndingText(implEnding);
    }

    private static class Key {
        public final Output output;
        public final NamedElement element;
        public final NamedElement context;

        Key(Output output, NamedElement element, NamedElement context) {
            this.output = output;
            this.element = element;
            this.context = context;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.context == null) {
                return this.output == other.output && this.element.equals(other.element) && other.context == null;
            }
            return this.output == other.output && this.element.equals(other.element) && this.context.equals(other.context);
        }

        public int hashCode() {
            return this.output.ordinal() ^ this.element.hashCode();
        }
    }

    public static enum Output {
        CapsuleClass,
        ProtocolClass,
        BasicClass,
        UserEnum,
        ProtocolBaseRole,
        ProtocolConjugateRole,
        SignalId,
        PortId,
        BorderPortId,
        InternalPortId,
        PartId,
        Deployment,
        UMLRTCapsuleClass,
        UMLRTTypeDescriptor,
        Artifact;

    }
}

