/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrusrt.codegen.cpp.AbstractElementGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.TypesUtil;
import org.eclipse.papyrusrt.codegen.cpp.rts.UMLRTRuntime;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Constructor;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppClass;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.CppNamespace;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Enumerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberField;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.MemberFunction;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.OffsetOf;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.PrimitiveType;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.UserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AbstractFunctionCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.AddressOfExpr;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BlockInitializer;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ConditionalDirective;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ElementAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.IntegralLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.MemberAccess;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.Sizeof;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.StringLiteral;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ReturnStatement;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Parameter;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.xtumlrt.util.XTUMLRTUtil;

public class ProtocolGenerator
extends AbstractElementGenerator {
    private static final String SIGNAL_VARIABLE_NAME = "signal";
    private final Protocol protocol;
    private final Map<Signal, Variable> payloadVariables = new HashMap<Signal, Variable>();

    public ProtocolGenerator(CppCodePattern cpp, Protocol protocol) {
        super(cpp);
        this.protocol = protocol;
    }

    @Override
    protected CppCodePattern.Output getOutputKind() {
        return CppCodePattern.Output.ProtocolClass;
    }

    @Override
    public String getLabel() {
        return String.valueOf(super.getLabel()) + ' ' + this.protocol.getName();
    }

    @Override
    public boolean generate() {
        ElementList elements = this.cpp.getElementList(CppCodePattern.Output.ProtocolClass, (NamedElement)this.protocol);
        CppNamespace cppProtocol = this.cpp.getWritableCppNamespace(CppCodePattern.Output.ProtocolClass, (NamedElement)this.protocol);
        CppClass baseRole = this.getRole(CppCodePattern.Output.ProtocolBaseRole);
        CppClass conjRole = this.getRole(CppCodePattern.Output.ProtocolConjugateRole);
        for (Signal signal : RTSModelLibraryUtils.getAllUserSignals((Protocol)this.protocol)) {
            Enumerator sigEnumerator = this.cpp.getEnumerator(CppCodePattern.Output.SignalId, (NamedElement)signal, XTUMLRTUtil.getOwner((CommonElement)signal));
            if (this.hasParameterWithStarAsType(signal)) {
                this.addSignalFunctionsStarAsType(elements, cppProtocol, baseRole, conjRole, signal, sigEnumerator);
                continue;
            }
            this.addSignalFunctions(elements, cppProtocol, baseRole, conjRole, signal, sigEnumerator);
        }
        return true;
    }

    private void addSignalFunctions(ElementList elements, CppNamespace cppProtocol, CppClass baseRole, CppClass conjRole, Signal signal, Enumerator sigEnumerator) {
        switch (signal.getKind()) {
            case IN: {
                conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                break;
            }
            case OUT: {
                baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                break;
            }
            case INOUT: {
                conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunction(elements, cppProtocol, signal, sigEnumerator));
                break;
            }
        }
    }

    private void addSignalFunctionsStarAsType(ElementList elements, CppNamespace cppProtocol, CppClass baseRole, CppClass conjRole, Signal signal, Enumerator sigEnumerator) {
        switch (signal.getKind()) {
            case IN: {
                conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithNoParam(elements, cppProtocol, signal, sigEnumerator));
                conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithRTTypedValueParam(elements, cppProtocol, signal, sigEnumerator));
                break;
            }
            case OUT: {
                baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithNoParam(elements, cppProtocol, signal, sigEnumerator));
                baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithRTTypedValueParam(elements, cppProtocol, signal, sigEnumerator));
                break;
            }
            case INOUT: {
                conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithNoParam(elements, cppProtocol, signal, sigEnumerator));
                baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithNoParam(elements, cppProtocol, signal, sigEnumerator));
                conjRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithRTTypedValueParam(elements, cppProtocol, signal, sigEnumerator));
                baseRole.addMember(CppClass.Visibility.PUBLIC, this.getSignalFunctionWithRTTypedValueParam(elements, cppProtocol, signal, sigEnumerator));
                break;
            }
        }
    }

    @Override
    public List<FileName> getGeneratedFilenames() {
        ArrayList<FileName> result = new ArrayList<FileName>();
        ElementList el = this.cpp.getElementList(CppCodePattern.Output.ProtocolClass, (NamedElement)this.protocol);
        result.add(el.getName());
        return result;
    }

    protected CppClass getRole(CppCodePattern.Output kind) {
        CppClass cls = this.cpp.getCppClass(kind, (NamedElement)this.protocol);
        cls.addBase(CppClass.Access.PUBLIC, (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)UMLRTRuntime.UMLRTProtocol.Element);
        Constructor ctor = this.cpp.getConstructor(kind, (NamedElement)this.protocol);
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter param = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(UMLRTRuntime.UMLRTCommsPort.getType().ptr().const_().ref(), "srcPort");
        ctor.add(param);
        AbstractFunctionCall baseCtorCall = UMLRTRuntime.UMLRTProtocol.Ctor();
        baseCtorCall.addArgument((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)param));
        ctor.addBaseInitializer(baseCtorCall);
        return cls;
    }

    protected MemberFunction getSignalFunction(ElementList elements, CppNamespace cppProtocol, Signal signal, Enumerator sigEnumerator) {
        MemberFunction f = new MemberFunction(UMLRTRuntime.UMLRTOutSignal.getType(), signal.getName(), Type.CVQualifier.CONST);
        Variable signalVar = new Variable(UMLRTRuntime.UMLRTOutSignal.getType(), SIGNAL_VARIABLE_NAME);
        f.add(signalVar);
        Variable payload = this.getPayloadDescriptor(elements, cppProtocol, signal);
        AbstractFunctionCall initialize = UMLRTRuntime.UMLRTSignal.initialize((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar), (Expression)new StringLiteral(signal.getName()), (Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)sigEnumerator), (Expression)UMLRTRuntime.UMLRTProtocol.srcPort(), (Expression)new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)payload)));
        f.add((Expression)initialize);
        for (Parameter param : signal.getParameters()) {
            org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter p = this.createSignalParameter(param);
            f.add(p);
            initialize.addArgument((Expression)new AddressOfExpr((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)p)));
        }
        f.add(new Statement[]{new ReturnStatement((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar))});
        return f;
    }

    protected MemberFunction getSignalFunctionWithNoParam(ElementList elements, CppNamespace cppProtocol, Signal signal, Enumerator sigEnumerator) {
        MemberFunction f = new MemberFunction(UMLRTRuntime.UMLRTOutSignal.getType(), signal.getName(), Type.CVQualifier.CONST);
        Variable signalVar = new Variable(UMLRTRuntime.UMLRTOutSignal.getType(), SIGNAL_VARIABLE_NAME);
        f.add(signalVar);
        AbstractFunctionCall initialize = UMLRTRuntime.UMLRTSignal.initialize((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar), (Expression)new StringLiteral(signal.getName()), (Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)sigEnumerator));
        f.add((Expression)initialize);
        f.add(new Statement[]{new ReturnStatement((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar))});
        return f;
    }

    protected MemberFunction getSignalFunctionWithRTTypedValueParam(ElementList elements, CppNamespace cppProtocol, Signal signal, Enumerator sigEnumerator) {
        MemberFunction f = new MemberFunction(UMLRTRuntime.UMLRTOutSignal.getType(), signal.getName(), Type.CVQualifier.CONST);
        String paramName = signal == null || ((Parameter)signal.getParameters().get(0)).getName() == null ? "data" : ((Parameter)signal.getParameters().get(0)).getName();
        org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter data = new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(UMLRTRuntime.UMLRTObject.UMLRTTypedValue.getType().const_().ref(), paramName);
        f.add(data);
        Variable signalVar = new Variable(UMLRTRuntime.UMLRTOutSignal.getType(), SIGNAL_VARIABLE_NAME);
        f.add(signalVar);
        AbstractFunctionCall initialize = UMLRTRuntime.UMLRTSignal.initialize((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar), (Expression)new StringLiteral(signal.getName()), (Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)sigEnumerator), (Expression)UMLRTRuntime.UMLRTProtocol.srcPort(), (Expression)new MemberAccess((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)data), (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)UMLRTRuntime.UMLRTObject.UMLRTTypedValue.type), (Expression)new MemberAccess((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)data), (org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)UMLRTRuntime.UMLRTObject.UMLRTTypedValue.data));
        f.add((Expression)initialize);
        f.add(new Statement[]{new ReturnStatement((Expression)new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)signalVar))});
        return f;
    }

    protected org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter createSignalParameter(Parameter param) {
        Type paramType = TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType());
        if (!(paramType instanceof PrimitiveType) && !paramType.isIndirect()) {
            paramType = paramType.const_().ref();
        }
        return new org.eclipse.papyrusrt.codegen.lang.cpp.element.Parameter(paramType, param.getName());
    }

    protected Variable getPayloadDescriptor(ElementList elements, CppNamespace cppProtocol, Signal signal) {
        Variable payload = this.payloadVariables.get(signal);
        if (payload == null) {
            BlockInitializer fieldsInit = new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType().arrayOf(null));
            Variable fields = new Variable(LinkageSpec.STATIC, fieldsInit.getType(), "fields_" + signal.getName(), (Expression)fieldsInit);
            elements.insertElement((IUserElement)fields, (IUserElement)cppProtocol);
            Expression sizeofPayload = null;
            int signalParamCount = signal.getParameters().size();
            if (signalParamCount == 0) {
                sizeofPayload = this.addEmptyParameterSignalField(signal, fieldsInit);
            } else if (signalParamCount == 1) {
                sizeofPayload = this.addSingleParameterSignalField(signal, fieldsInit);
            } else if (signalParamCount > 1) {
                sizeofPayload = this.addMultiParameterSignalFields(elements, signal, fieldsInit, fields);
            }
            payload = new Variable(LinkageSpec.STATIC, UMLRTRuntime.UMLRTObject.getObjectType(), "payload_" + signal.getName(), (Expression)new BlockInitializer(UMLRTRuntime.UMLRTObject.getObjectType(), new Expression[]{sizeofPayload == null ? new IntegralLiteral(0) : sizeofPayload, new IntegralLiteral(fields.getNumInitializedInstances()), new ElementAccess((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)fields)}));
            elements.insertElement((IUserElement)payload, (IUserElement)cppProtocol);
            this.payloadVariables.put(signal, payload);
        }
        return payload;
    }

    private Expression addEmptyParameterSignalField(Signal signal, BlockInitializer fieldsInit) {
        fieldsInit.addExpression((Expression)new ConditionalDirective(ConditionalDirective.Directive.IFDEF, "NEED_NON_FLEXIBLE_ARRAY", new Expression[]{new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType(), new Expression[]{new IntegralLiteral(0), new IntegralLiteral(0), new IntegralLiteral(0), new IntegralLiteral(0), new IntegralLiteral(0)}), new ConditionalDirective(ConditionalDirective.Directive.ENDIF)}));
        return null;
    }

    private Expression addMultiParameterSignalFields(ElementList elements, Signal signal, BlockInitializer fieldsInit, Variable fields) {
        Sizeof sizeofPayload = null;
        CppClass packingStruct = new CppClass(UserElement.GenerationTarget.DEFN_ONLY, CppClass.Kind.STRUCT, "params_" + signal.getName());
        elements.insertElement((IUserElement)packingStruct, (IUserElement)fields);
        for (Parameter param : signal.getParameters()) {
            String fieldName = param.getName();
            packingStruct.addMember(CppClass.Visibility.PUBLIC, new MemberField(TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType()), fieldName));
            fieldsInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType(), new Expression[]{new StringLiteral(fieldName), new AddressOfExpr(TypesUtil.createRTTypeAccess(this.cpp, (NamedElement)param, param.getType())), new OffsetOf(packingStruct, fieldName), new IntegralLiteral(1), new IntegralLiteral(0)}));
            sizeofPayload = new Sizeof((org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement)packingStruct);
        }
        return sizeofPayload;
    }

    private Expression addSingleParameterSignalField(Signal signal, BlockInitializer fieldsInit) {
        Parameter param = (Parameter)signal.getParameters().get(0);
        fieldsInit.addExpression((Expression)new BlockInitializer(UMLRTRuntime.UMLRTObject.getFieldType(), new Expression[]{new StringLiteral(param.getName()), new AddressOfExpr(TypesUtil.createRTTypeAccess(this.cpp, (NamedElement)param, param.getType())), new IntegralLiteral(0), new IntegralLiteral(1), new IntegralLiteral(0)}));
        Sizeof sizeofPayload = new Sizeof(TypesUtil.createCppType(this.cpp, (NamedElement)param, param.getType()));
        return sizeofPayload;
    }

    protected boolean hasParameterWithStarAsType(Signal signal) {
        EList parameters;
        boolean result = false;
        if (signal != null && (parameters = signal.getParameters()) != null && !parameters.isEmpty()) {
            Parameter param = (Parameter)parameters.get(0);
            result = param.getType() == null;
        }
        return result;
    }
}

