/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class ConditionalDirective
extends Expression {
    private final Directive directive;
    private final String condition;
    private ExpressionList exprs;

    public ConditionalDirective(Directive directive) {
        this.directive = directive;
        this.condition = null;
    }

    public ConditionalDirective(Directive directive, String condition) {
        this.directive = directive;
        this.condition = condition;
    }

    public ConditionalDirective(Directive directive, String condition, Expression ... exprs) {
        this.exprs = new ExpressionList(exprs);
        this.directive = directive;
        this.condition = condition;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return false;
    }

    @Override
    protected Type createType() {
        return null;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return null;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        fmt.disableIndent();
        String cond = this.condition != null && this.condition.trim().length() > 0 ? " " + this.condition : "";
        fmt.writeLn(String.valueOf(this.directive.toString()) + cond);
        if (!fmt.enableIndent()) {
            return false;
        }
        return this.exprs != null ? this.exprs.write(fmt) : true;
    }

    public static enum Directive {
        IFDEF,
        IFNDEF,
        IF,
        ELIF,
        ELSE,
        ENDIF;


        public final String toString() {
            return "#" + this.name().toLowerCase();
        }
    }
}

