/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.stmt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class UserCode
extends Statement {
    private final DependencyBlob dependencies;
    private final String code;
    private final int indentation;
    private final boolean indentFirstLine;

    public UserCode(String code) {
        this(null, code);
    }

    public UserCode(String code, int indentation) {
        this(null, code, indentation);
    }

    public UserCode(DependencyBlob dependencies, String code) {
        this(dependencies, code, 0);
    }

    public UserCode(DependencyBlob dependencies, String code, int indentation) {
        this(dependencies, code, indentation, true);
    }

    public UserCode(DependencyBlob dependencies, String code, int indentation, boolean indentFirstLine) {
        this.dependencies = dependencies;
        this.code = code;
        this.indentation = indentation;
        this.indentFirstLine = indentFirstLine;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.dependencies == null ? true : deps.add(this.dependencies);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean write(CppFormatter fmt) {
        BufferedReader reader = new BufferedReader(new StringReader(this.code));
        String line = null;
        try {
            String str;
            do {
                if ((line = reader.readLine()) != null) continue;
                return true;
            } while ((str = this.formatLine(line)) == null || fmt.writeLn(str));
            return false;
        }
        catch (IOException e) {
            CodeGenPlugin.error((Throwable)e);
            return false;
        }
    }

    private String formatLine(String line) {
        StringBuilder builder = new StringBuilder();
        int l = line.length();
        if (l == 0) {
            return null;
        }
        int i = 0;
        i = 0;
        while (i < this.indentation) {
            builder.append(' ');
            ++i;
        }
        char[] array = line.toCharArray();
        i = 0;
        while (i < l && (array[i] == ' ' || array[i] == '\t')) {
            ++i;
        }
        while (i < l && array[i] != '\n') {
            builder.append(array[i]);
            ++i;
        }
        return builder.toString();
    }
}

