/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractUMLRT2CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.cpp.CppProjectGenerator;
import org.eclipse.papyrusrt.codegen.cpp.XTUMLRT2CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.utils.ProjectUtils;

public final class UMLRTGenerator
extends AbstractUMLRT2CppCodeGenerator {
    public static UMLRTGenerator INSTANCE = new UMLRTGenerator();
    private static final String FAILED_TO_CREATE_OUTPUT_PROJECT = "Failed to create output project";

    private UMLRTGenerator() {
        this.setStandalone(false);
    }

    public IStatus generate(List<EObject> elements, String top, boolean uml) {
        IStatus status = super.generate(elements, top, uml);
        HashSet<IProject> projects = new HashSet<IProject>();
        for (EObject e : elements) {
            IProject p = this.getProject(e);
            if (p == null) continue;
            projects.add(p);
        }
        for (IProject p : projects) {
            try {
                p.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
        return status;
    }

    protected File getModelFolder(EObject eobj) {
        URI eobjUri;
        File modelFolder = null;
        if (eobj != null && (eobjUri = EcoreUtil.getURI((EObject)eobj)) != null) {
            IContainer modelContainer;
            Path path = new Path(eobjUri.toPlatformString(true));
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            if (file != null && file.exists() && (modelContainer = file.getParent()) != null && modelContainer.exists()) {
                modelFolder = modelContainer.getLocation().makeAbsolute().toFile();
            }
        }
        return modelFolder;
    }

    public File getOutputFolder(EObject eobj) {
        return this.getOutputFolder(eobj, null);
    }

    protected File getOutputFolder(EObject eobj, XTUMLRT2CppCodeGenerator codeGen) {
        IProject project = this.getProject(eobj, codeGen);
        IFolder folder = project.getFolder("src");
        try {
            folder.refreshLocal(0, null);
        }
        catch (CoreException e) {
            CodeGenPlugin.error((String)"could not refresh output folder", (Throwable)e);
        }
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                CodeGenPlugin.error((String)"could not create output folder", (Throwable)e);
            }
        }
        return folder.getRawLocation().toFile();
    }

    public IProject getProject(EObject eobj) {
        return this.getProject(eobj, null);
    }

    public IProject getProject(EObject eobj, XTUMLRT2CppCodeGenerator codeGen) {
        boolean generationResult = false;
        boolean projectExists = false;
        String projectName = ProjectUtils.getProjectName((EObject)eobj);
        projectName = String.valueOf(projectName) + "_CDTProject";
        String rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            this.resetResource(eobj, codeGen);
            generationResult = new CppProjectGenerator().generate(rootPath, projectName);
            if (generationResult) {
                try {
                    IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(rootPath) + "/" + projectName + "/.project"));
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
                    project.create(description, null);
                    projectExists = true;
                }
                catch (CoreException coreException) {
                    CodeGenPlugin.error((String)FAILED_TO_CREATE_OUTPUT_PROJECT);
                }
            } else {
                CodeGenPlugin.error((String)FAILED_TO_CREATE_OUTPUT_PROJECT);
            }
        } else {
            projectExists = true;
        }
        if (projectExists && !project.isOpen()) {
            try {
                project.open((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                CodeGenPlugin.error((String)"Failed to open project");
            }
        }
        return projectExists && project.isOpen() && project != null ? project : null;
    }
}

