/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.cdt;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public final class EditorUtil {
    private EditorUtil() {
    }

    public static void openEditor(final IFile file, final UserEditableRegion.Label label, final MultiStatus rc) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    int line = UserEditableRegion.LOCATOR.getLineNumber(file, label);
                    if (line > 0 && !EditorUtil.navigateWithSelectAndReveal(rc, part, file, line)) {
                        EditorUtil.navigateWithMarker(rc, part, file, line);
                    }
                }
                catch (PartInitException e) {
                    rc.add((IStatus)new Status(4, "org.eclipse.papyrusrt.codegen.papyrus", e.getMessage()));
                }
            }
        });
    }

    private static boolean navigateWithSelectAndReveal(MultiStatus rc, IEditorPart part, IFile file, int line) {
        ITextEditor textEditor;
        IDocument doc;
        boolean result = false;
        if (part instanceof ITextEditor && (doc = (textEditor = (ITextEditor)part).getDocumentProvider().getDocument((Object)part.getEditorInput())) != null) {
            try {
                textEditor.selectAndReveal(doc.getLineOffset(line), 0);
                result = true;
            }
            catch (BadLocationException e) {
                rc.add((IStatus)new Status(4, "org.eclipse.papyrusrt.codegen.papyrus", e.getMessage()));
            }
        }
        return result;
    }

    private static boolean navigateWithMarker(MultiStatus rc, IEditorPart part, IFile file, int line) {
        boolean result = false;
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.marker");
            marker.setAttribute("lineNumber", line);
            IDE.gotoMarker((IEditorPart)part, (IMarker)marker);
            result = true;
        }
        catch (CoreException e) {
            rc.add((IStatus)new Status(4, "org.eclipse.papyrusrt.codegen.papyrus", e.getMessage()));
        }
        return result;
    }
}

