/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.cdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.IEObjectLocator;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.Vertex;

public class UMLEObjectLocator
implements IEObjectLocator {
    public static final String LANGUAGE = "C++";
    private ModelSet modelSet = new ModelSet();

    private Package getRoot(String uri) {
        Package result = null;
        Resource r = this.modelSet.getResource(URI.createURI((String)uri), true);
        result = (Package)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        return result;
    }

    public EObject getEObject(UserEditableRegion.Label label) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.addAll(Arrays.asList(label.getQualifiedName().split("::")));
        Package nextPackage = this.getRoot(label.getUri());
        Class capsuleOrClass = null;
        qualifiedNames.remove(0);
        while (!qualifiedNames.isEmpty()) {
            String qname = (String)qualifiedNames.remove(0);
            Package pkg = nextPackage.getNestedPackage(qname);
            if (pkg == null) {
                capsuleOrClass = (Class)nextPackage.getPackagedElement(qname, false, UMLPackage.Literals.CLASS, false);
                break;
            }
            nextPackage = pkg;
        }
        EObject result = null;
        if (capsuleOrClass == null) {
            CodeGenPlugin.error((String)("Element not found : " + label.getQualifiedName()));
        } else if (label.getType().equals(UMLPackage.Literals.OPERATION.getName().toLowerCase())) {
            Operation op = capsuleOrClass.getOwnedOperation(label.getDetails(), null, null);
            OpaqueBehavior behaviour = (OpaqueBehavior)capsuleOrClass.getOwnedBehavior(op.getName().toLowerCase(), false, UMLPackage.Literals.OPAQUE_BEHAVIOR, true);
            if (!behaviour.getLanguages().contains((Object)LANGUAGE)) {
                behaviour.getLanguages().add((Object)LANGUAGE);
            }
            op.getMethods().add((Object)behaviour);
            result = behaviour;
        } else {
            EObject smElement = this.getSMElement(capsuleOrClass, qualifiedNames);
            result = this.getUserCodeElement(smElement, label.getType(), label.getDetails());
        }
        return result;
    }

    private EObject getUserCodeElement(EObject container, String type, String details) {
        Transition t;
        Behavior result = null;
        if (type.equals(UMLPackage.Literals.TRANSITION.getName().toLowerCase())) {
            Transition t2 = this.getTransition(container, details);
            if (t2 != null) {
                result = t2.getEffect();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__ENTRY.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getEntry();
            }
        } else if (type.equals(UMLPackage.Literals.STATE__EXIT.getName())) {
            if (container instanceof State) {
                State s = (State)container;
                result = s.getExit();
            }
        } else if (type.equals(UMLPackage.Literals.TRANSITION__GUARD.getName()) && (t = this.getTransition(container, details)) != null) {
            result = t.getGuard();
        }
        return result;
    }

    private EObject getSMElement(Class capsuleOrClass, List<String> qnameRelativeToSM) {
        Region r;
        StateMachine sm = (StateMachine)capsuleOrClass.getOwnedBehaviors().get(0);
        Region nextRegion = r = (Region)sm.getRegions().get(0);
        StateMachine result = sm;
        while (!qnameRelativeToSM.isEmpty()) {
            Vertex v = nextRegion.getSubvertex(qnameRelativeToSM.remove(0));
            if (v == null) {
                CodeGenPlugin.error((String)"No matching element found.");
                break;
            }
            if (!((State)v).getRegions().isEmpty()) {
                nextRegion = (Region)((State)v).getRegions().get(0);
            }
            result = v;
        }
        if (!qnameRelativeToSM.isEmpty()) {
            CodeGenPlugin.error((String)"No matching element found");
            result = null;
        }
        return result;
    }

    private Transition getTransition(EObject container, String transitionDetails) {
        Transition result = null;
        Region region = null;
        region = container instanceof StateMachine ? (Region)((StateMachine)container).getRegions().get(0) : (Region)((State)container).getRegions().get(0);
        if (region != null) {
            UserEditableRegion.TransitionDetails details = new UserEditableRegion.TransitionDetails(transitionDetails);
            for (Transition t : region.getTransitions()) {
                if (!UMLEObjectLocator.getSMQualifiedName((EObject)t.getSource()).equals(details.getSourceQname()) || !UMLEObjectLocator.getSMQualifiedName((EObject)t.getTarget()).equals(details.getTargetQname())) continue;
                if (details.getTriggerDetailMap().isEmpty()) {
                    result = t;
                    break;
                }
                boolean found = false;
                for (Map.Entry entry : details.getTriggerDetailMap().entrySet()) {
                    for (Trigger triger : t.getTriggers()) {
                        if (!triger.getEvent().getName().equals(entry.getKey()) || !this.comparetriggerPorts((List<Port>)triger.getPorts(), (List)entry.getValue())) continue;
                        found = true;
                        break;
                    }
                    if (!found) break;
                }
                if (!found) continue;
                result = t;
                break;
            }
        }
        return result;
    }

    private boolean comparetriggerPorts(List<Port> ports, List<String> expectedPorts) {
        ArrayList<String> actualPorts = new ArrayList<String>();
        for (Port p : ports) {
            actualPorts.add(p.getName());
        }
        actualPorts.retainAll(expectedPorts);
        return actualPorts.size() == expectedPorts.size();
    }

    public static String getSMQualifiedName(EObject eObject) {
        String result = "";
        EObject container = eObject;
        while (container != null && !(container instanceof StateMachine)) {
            if (container instanceof Vertex) {
                if (result.length() != 0) {
                    result = "::" + result;
                }
                result = String.valueOf(((Vertex)container).getName()) + result;
            }
            container = container.eContainer();
        }
        return result;
    }
}

