/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.papyrus.propertytester;

import java.util.List;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsuleUtils;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Transition;

public class UMLRTPropertyTester
extends PropertyTester {
    private static final String STEREOTYPE_PROPERTY = "stereotype";
    private static final String ECLASS_PROPERTY = "eClass";
    private static final String IS_SOURCE_EDITABLE_PROPERTY = "isSourceEditable";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        EObject eobj;
        boolean result = false;
        Object element = null;
        if (receiver instanceof List) {
            element = ((List)receiver).get(0);
        }
        if ((eobj = EMFHelper.getEObject(element)) != null) {
            if (eobj instanceof Element && STEREOTYPE_PROPERTY.equals(property)) {
                Stereotype st = ((Element)eobj).getAppliedStereotype((String)expectedValue);
                result = st != null;
            } else if (ECLASS_PROPERTY.equals(property)) {
                result = eobj.eClass().getName().equals(expectedValue);
            } else if (IS_SOURCE_EDITABLE_PROPERTY.equals(property)) {
                result = ((Boolean)expectedValue).booleanValue() == this.isSourceEditable(eobj);
            }
        }
        return result;
    }

    private boolean isSourceEditable(EObject eo) {
        Transition t;
        EObject container;
        boolean result = false;
        if (eo instanceof Classifier && CapsuleUtils.isCapsule((Classifier)((Classifier)eo))) {
            result = true;
        } else if (eo instanceof Transition) {
            result = true;
        } else if (eo instanceof Constraint && (container = eo.eContainer()) instanceof Transition && (t = (Transition)container).getGuard() == eo) {
            result = true;
        }
        return result;
    }
}

