/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.canonical;

import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.custom.canonical.StructuredClassifierSemanticChildrenStrategy;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

/**
 * Semantic children strategy for parts in an RT composite, defining specific
 * restrictions on the inclusion of parts.
 */
public class RTClassSemanticChildrenStrategy extends StructuredClassifierSemanticChildrenStrategy {

	public RTClassSemanticChildrenStrategy() {
		super();
	}

	/**
	 * Excludes attributes that are not {@link Port}s and are not
	 * {@link CapsulePart}s.
	 */
	@Override
	public List<? extends EObject> getCanonicalSemanticChildren(EObject semanticFromEditPart, View viewFromEditPart) {
		List<? extends EObject> result = super.getCanonicalSemanticChildren(semanticFromEditPart, viewFromEditPart);

		if (result != null) {
			// Remove plain attributes
			for (Iterator<? extends EObject> iter = result.iterator(); iter.hasNext();) {
				EObject next = iter.next();
				if ((next instanceof Property) && !(next instanceof Port)) {
					Property part = (Property) next;
					if (!CapsulePartUtils.isCapsulePart(part)) {
						// Don't present it in the diagram
						iter.remove();
					}
				}
			}
		}

		return result;
	}
}
