/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.PropertyPartEditPartCN;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.editparts.IRTPortEditPart;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.figures.RTPropertyPartFigure;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.locator.RTPortPositionLocator;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class RTPropertyPartEditPart
extends PropertyPartEditPartCN {
    private static final int LAYER_OPACITY = 0;
    private static final int Y_OFFSET = -2;
    private static final int X_OFFSET = 2;
    private static final int LAYER_NUMBER = 1;
    private static final String PATTERN_PATH = "/icons/hash_pattern_grey.png";
    Adapter multiplicityValueListener;

    public RTPropertyPartEditPart(View view) {
        super(view);
    }

    protected void addSemanticListeners() {
        super.addSemanticListeners();
        this.multiplicityValueListener = this.getMultiplicityListener();
        if (this.hasNotationView() && this.getNotationView().isSetElement()) {
            Element element = this.getUMLElement();
            element.eAdapters().add((Object)this.multiplicityValueListener);
            if (((MultiplicityElement)element).getLowerValue() != null) {
                ((MultiplicityElement)element).getLowerValue().eAdapters().add((Object)this.multiplicityValueListener);
            }
            if (((MultiplicityElement)element).getUpperValue() != null) {
                ((MultiplicityElement)this.getUMLElement()).getUpperValue().eAdapters().add((Object)this.multiplicityValueListener);
            }
        }
    }

    protected void removeSemanticListeners() {
        super.removeSemanticListeners();
        if (this.hasNotationView() && this.getNotationView().isSetElement()) {
            Element element = this.getUMLElement();
            if (element != null) {
                element.eAdapters().remove((Object)this.multiplicityValueListener);
            }
            if (element instanceof MultiplicityElement) {
                MultiplicityElement mult = (MultiplicityElement)element;
                if (mult.getLowerValue() != null) {
                    mult.getLowerValue().eAdapters().remove((Object)this.multiplicityValueListener);
                }
                if (mult.getUpperValue() != null) {
                    mult.getUpperValue().eAdapters().remove((Object)this.multiplicityValueListener);
                }
                this.multiplicityValueListener = null;
            }
        }
    }

    protected Adapter getMultiplicityListener() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                Object feature = notification.getFeature();
                if (RTPropertyPartEditPart.this.hasNotationView() && RTPropertyPartEditPart.this.getNotationView().isSetElement()) {
                    ValueSpecification upperValue;
                    Element element = RTPropertyPartEditPart.this.getUMLElement();
                    if (notifier == element && feature == UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue() && type == 1) {
                        ValueSpecification lowerValue = ((MultiplicityElement)notifier).getLowerValue();
                        if (lowerValue != null) {
                            lowerValue.eAdapters().add((Object)RTPropertyPartEditPart.this.multiplicityValueListener);
                        }
                    } else if (notifier == element && feature == UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue() && type == 1 && (upperValue = ((MultiplicityElement)notifier).getUpperValue()) != null) {
                        upperValue.eAdapters().add((Object)RTPropertyPartEditPart.this.multiplicityValueListener);
                    }
                    if (notifier instanceof ValueSpecification && ((ValueSpecification)notifier).eContainer().equals(element)) {
                        RTPropertyPartEditPart.this.refreshVisuals();
                    }
                }
            }
        };
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new RTPropertyPartFigure();
        return this.primaryShape;
    }

    public RTPropertyPartFigure getPrimaryShape() {
        return (RTPropertyPartFigure)this.primaryShape;
    }

    protected void refreshVisuals() {
        if (this.hasNotationView() && this.getNotationView().isSetElement()) {
            boolean isHash = ((MultiplicityElement)this.getUMLElement()).getLower() == 0;
            this.getPrimaryShape().setHashed(isHash);
            boolean stack = 1 < ((MultiplicityElement)this.getUMLElement()).getUpper();
            this.getPrimaryShape().setStack(stack);
        }
        this.getPrimaryShape().setLayerNumber(1);
        this.getPrimaryShape().setXOffSet(2.0);
        this.getPrimaryShape().setYOffSet(-2.0);
        this.getPrimaryShape().setPathPattern(PATTERN_PATH);
        this.getPrimaryShape().setLayerOpacity(0);
        super.refreshVisuals();
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        boolean result;
        if (IRTPortEditPart.isPortOnPart(childEditPart)) {
            IRTPortEditPart portOnPart = (IRTPortEditPart)childEditPart;
            if (this.hasNotationView() && this.getNotationView().isSetElement()) {
                RTPortPositionLocator locator = new RTPortPositionLocator((Element)portOnPart.getPort(), this.getMainFigure(), 0, portOnPart.getDefaultScaleFactor());
                this.getBorderedFigure().getBorderItemContainer().add(portOnPart.getFigure(), (Object)locator);
            }
            result = true;
        } else {
            result = super.addFixedChild(childEditPart);
        }
        return result;
    }
}

