/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.ILocationIterator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.RelativePortLocation;

public class BorderMarchIterator
implements ILocationIterator {
    private static final int CLOCKWISE = 1;
    private static final int ANTICLOCKWISE = -1;
    private final Rectangle bounds;
    private final int firstBase;
    private final int secondBase;
    private final int thirdBase;
    private final int perimeter;
    private final int direction;
    private int current;

    private BorderMarchIterator(Rectangle bounds, int direction, Point start) {
        this.bounds = bounds;
        this.firstBase = bounds.width();
        this.secondBase = this.firstBase + bounds.height();
        this.thirdBase = this.secondBase + bounds.width();
        this.perimeter = this.thirdBase + bounds.height();
        this.direction = direction;
        this.current = this.where(start);
    }

    public static ILocationIterator from(Point startingAt, Rectangle onBorder) {
        int direction;
        Rectangle bounds = onBorder.getCopy();
        Point startRelativeToBorder = startingAt.getTranslated(bounds.getLocation().getNegated());
        switch (RelativePortLocation.getSide(startRelativeToBorder, bounds)) {
            case 1: 
            case 16: {
                direction = 1;
                break;
            }
            default: {
                direction = -1;
            }
        }
        return new BorderMarchIterator(bounds, direction, startingAt);
    }

    @Override
    public Point next(int distance) {
        this.current = (this.current + this.direction * distance) % this.perimeter;
        return this.where();
    }

    @Override
    public Point where() {
        Point result = this.current <= this.firstBase ? this.bounds.getTopRight().getTranslated(this.current - this.firstBase, 0) : (this.current <= this.secondBase ? this.bounds.getTopRight().getTranslated(0, this.current - this.firstBase) : (this.current <= this.thirdBase ? this.bounds.getBottomLeft().getTranslated(this.thirdBase - this.current, 0) : this.bounds.getBottomLeft().getTranslated(0, this.thirdBase - this.current)));
        return result;
    }

    private int where(Point location) {
        int result;
        Point relativeToBorder = location.getTranslated(this.bounds.getLocation().getNegated());
        switch (RelativePortLocation.getSide(relativeToBorder, this.bounds)) {
            case 1: {
                result = Math.max(this.bounds.x(), Math.min(location.x(), this.bounds.right())) - this.bounds.x();
                break;
            }
            case 16: {
                result = this.firstBase + Math.max(this.bounds.y(), Math.min(location.y(), this.bounds.bottom())) - this.bounds.y();
                break;
            }
            case 4: {
                result = this.thirdBase - (Math.max(this.bounds.x(), Math.min(location.x(), this.bounds.right())) - this.bounds.x());
                break;
            }
            case 8: {
                result = this.perimeter - (Math.max(this.bounds.y(), Math.min(location.y(), this.bounds.bottom())) - this.bounds.y());
                break;
            }
            default: {
                throw new IllegalArgumentException("cannot compute location of " + location);
            }
        }
        return result;
    }
}

