/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.internal.utils.ILocationIterator;

public class LinearIterator
implements ILocationIterator {
    private final double unitX;
    private final double unitY;
    private Point current;

    private LinearIterator(double angle, Point start) {
        this.unitX = Math.cos(angle);
        this.unitY = Math.sin(angle);
        this.current = start.getCopy();
    }

    public static LinearIterator from(Point startingAt, double direction) {
        return new LinearIterator(direction, startingAt);
    }

    public static LinearIterator from(Point startingAt) {
        return LinearIterator.from(startingAt, 0.7853981633974483);
    }

    @Override
    public Point next(int distance) {
        this.current = this.current.getTranslated(Math.rint(this.unitX * (double)distance), Math.rint(this.unitY * (double)distance));
        return this.where();
    }

    @Override
    public Point where() {
        return this.current;
    }
}

