/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.diagram.common.utils;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.diagram.common.figures.IStackedFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DrawFigureUtils {
    public static void paintStack(IStackedFigure figure, Graphics graphics) {
        if (figure instanceof NodeFigure && figure instanceof IRoundedRectangleFigure) {
            Rectangle bounds = ((NodeFigure)figure).getBounds();
            Rectangle clip = bounds.getCopy();
            IRoundedRectangleFigure roundedFigure = (IRoundedRectangleFigure)figure;
            int i = figure.getLayerNumber();
            while (i > 0) {
                Rectangle layer = bounds.getCopy();
                layer.translate((double)i * figure.getXOffSet(), (double)i * figure.getYOffSet());
                Rectangle clipRectangle = graphics.getClip(clip).getUnion(layer).expand(1, 1);
                graphics.setClip(clipRectangle.getCopy());
                graphics.pushState();
                graphics.setAlpha(figure.getLayerOpacity());
                graphics.fillRoundRectangle(layer, ((IRoundedRectangleFigure)figure).getCornerDimensions().width, ((IRoundedRectangleFigure)figure).getCornerDimensions().height);
                DrawFigureUtils.replicateBackground((NodeFigure)figure, graphics, layer);
                graphics.popState();
                graphics.setLineWidth(figure.getLayerLineWidth());
                graphics.drawRoundRectangle(layer, roundedFigure.getCornerDimensions().width, roundedFigure.getCornerDimensions().height);
                --i;
            }
        }
    }

    public static void replicateBackground(NodeFigure figure, Graphics graphics, Rectangle layer) {
        if (figure.isUsingGradient()) {
            DrawFigureUtils.replicateGradient(figure, graphics, layer);
        } else {
            graphics.setBackgroundColor(figure.getBackgroundColor());
        }
    }

    public static void replicateGradient(NodeFigure figure, Graphics graphics, Rectangle rectangle) {
        if (figure instanceof NodeFigure) {
            DrawFigureUtils.fillGradient(DrawFigureUtils.getColor(figure.getGradientColor2()), DrawFigureUtils.getColor(figure.getGradientColor1()), graphics, rectangle, figure.getGradientStyle() == 0);
        }
    }

    public static Color getColor(int integerColor) {
        return ColorRegistry.getInstance().getColor(Integer.valueOf(integerColor));
    }

    public static void fillGradient(Color gradiantColor1, Color gradientColor2, Graphics graphics, Rectangle rectangle, boolean style) {
        graphics.setForegroundColor(gradiantColor1);
        graphics.setBackgroundColor(gradientColor2);
        graphics.fillGradient(rectangle.getCopy(), style);
    }

    public static void paintPattern(IRoundedRectangleFigure figure, Graphics graphics, String patternPath) {
        Image hashImage = Activator.getPluginIconImage((String)"org.eclipse.papyrusrt.umlrt.tooling.ui", (String)patternPath);
        int imageWidth = hashImage.getBounds().width;
        int imageHeight = hashImage.getBounds().height;
        int horizontalTimes = figure.getBounds().width() / imageWidth + 1;
        int verticalTimes = figure.getBounds().height() / imageHeight + 1;
        Point origin = new Point(figure.getBounds().getLocation());
        Rectangle clipRectangle = figure.getBounds().getCopy();
        int verticalTime = 0;
        while (verticalTime < verticalTimes) {
            int horizontalTime = 0;
            while (horizontalTime < horizontalTimes) {
                graphics.pushState();
                graphics.getClip(clipRectangle);
                graphics.setClip(clipRectangle.expand(-1, -1));
                graphics.drawImage(hashImage, origin);
                graphics.popState();
                origin.translate(imageWidth, 0);
                ++horizontalTime;
            }
            origin.setX(figure.getBounds().getLocation().x());
            origin.translate(0, imageHeight);
            ++verticalTime;
        }
    }
}

