/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editparts;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RoundedRectangleNodePlateFigure;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.PseudostateDeepHistoryEditPart;

/**
 * RT specialization of the deep-history edit part.
 */
public class RTPseudostateDeepHistoryEditPart extends PseudostateDeepHistoryEditPart implements IRTPseudostateEditPart {

	/**
	 * Initializes me with my notation view.
	 *
	 * @param view
	 *            my notation view
	 */
	public RTPseudostateDeepHistoryEditPart(View view) {
		super(view);
	}

	@Override
	protected NodeFigure createNodePlate() {
		Dimension defaultSize = getDefaultSize();
		RoundedRectangleNodePlateFigure result = new RoundedRectangleNodePlateFigure(defaultSize.width(), defaultSize.height());
		return result;
	}

}
