/*****************************************************************************
 * Copyright (c) 2016 Christian W. Damus and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Christian W. Damus - Initial API and implementation
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.diagram.statemachine.internal.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.policies.CustomStateCreationEditPolicy;

/**
 * RT-specific state creation edit policy to handle creation of RT-specific connection
 * point views.
 */
public class RTStateCreationEditPolicy extends CustomStateCreationEditPolicy {

	private final RTSideAffixedNodesCreationEditPolicy sideAffixed = new RTSideAffixedNodesCreationEditPolicy();

	/**
	 * Initializes me.
	 */
	public RTStateCreationEditPolicy() {
		super();
	}

	@Override
	public void setHost(EditPart host) {
		sideAffixed.setHost(host);
		super.setHost(host);
	}

	@Override
	public void activate() {
		sideAffixed.activate();
		super.activate();
	}

	@Override
	public void deactivate() {
		super.deactivate();
		sideAffixed.deactivate();
	}

	IGraphicalEditPart getGraphicalHost() {
		return (IGraphicalEditPart) getHost();
	}

	/**
	 * Extend the inherited method to capture the element being added (if any).
	 */
	@Override
	protected ICommand getSetBoundsCommand(CreateViewRequest request, ViewDescriptor descriptor) {
		return sideAffixed.getSetBoundsCommand(request, descriptor);
	}

	@Override
	protected PortPositionLocator getPositionLocator() {
		return sideAffixed.getPositionLocator();
	}

}
