/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.modelexplorer.utils;

import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.papyrusrt.umlrt.core.utils.InterfaceRealizationUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.MessageSetUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolContainerUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.RTMessageUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UsageUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Usage;

public class LabelUtils {
    public static String getProtocolContainerLabel(Package protocolContainer, IItemLabelProvider referenceLabelProvider) {
        Collaboration collaboration = ProtocolContainerUtils.getProtocol((Package)protocolContainer);
        if (collaboration != null && collaboration.getName() != null) {
            return String.valueOf(referenceLabelProvider.getText((Object)protocolContainer)) + " " + collaboration.getName();
        }
        return referenceLabelProvider.getText((Object)protocolContainer);
    }

    public static String getCallEventForProtocolMessageLabel(CallEvent callEvent, IItemLabelProvider referenceLabelProvider) {
        Operation operation = callEvent.getOperation();
        if (operation != null && operation.getName() != null) {
            RTMessageKind kind = RTMessageUtils.getMessageKind((Object)operation);
            String direction = kind != null ? kind.getName() : "";
            return String.valueOf(direction) + " " + operation.getName();
        }
        return referenceLabelProvider.getText((Object)callEvent);
    }

    public static String getMessageSetLabel(Interface messageSet, IItemLabelProvider referenceLabelProvider) {
        Collaboration protocol;
        RTMessageKind kind = MessageSetUtils.getMessageKind((Object)messageSet);
        if (kind != null && (protocol = MessageSetUtils.getProtocol((Interface)messageSet)) != null) {
            switch (kind) {
                case IN: {
                    return MessageSetUtils.computeInterfaceInName((String)protocol.getName());
                }
                case OUT: {
                    return MessageSetUtils.computeInterfaceOutName((String)protocol.getName());
                }
                case IN_OUT: {
                    return MessageSetUtils.computeInterfaceInOutName((String)protocol.getName());
                }
            }
            return protocol.getName();
        }
        return referenceLabelProvider.getText((Object)messageSet);
    }

    public static String getInterfaceRealizationLabel(InterfaceRealization interfaceRealization, IItemLabelProvider referenceLabelProvider) {
        Interface messageSet = InterfaceRealizationUtils.getMessageSet((InterfaceRealization)interfaceRealization);
        if (messageSet != null) {
            return LabelUtils.getMessageSetLabel(messageSet, referenceLabelProvider);
        }
        return referenceLabelProvider.getText((Object)interfaceRealization);
    }

    public static String getUsageLabel(Usage usage, IItemLabelProvider referenceLabelProvider) {
        Interface messageSet = UsageUtils.getMessageSet((Usage)usage);
        if (messageSet != null) {
            return LabelUtils.getMessageSetLabel(messageSet, referenceLabelProvider);
        }
        return referenceLabelProvider.getText((Object)usage);
    }
}

