/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.properties.editors;

import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.AbstractListEditor;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.utils.EMFHacks;
import org.eclipse.papyrusrt.umlrt.tooling.properties.Activator;
import org.eclipse.papyrusrt.umlrt.tooling.ui.internal.types.UMLRTUIElementTypesEnumerator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public class ParameterControlEditor
extends AbstractListEditor
implements SelectionListener,
DisposeListener {
    private static final String MOVE_DOWN = "Move Down";
    private static final String REMOVE_ELEMENT = "Remove Element";
    private static final String MOVE_UP = "Move Up";
    private static final String DELETE_BUTTON_ICON = "/icons/Delete_12x12.gif";
    private static final String ADD_BUTTON_ICON = "/icons/Add_12x12.gif";
    private static final String DOWN_BUTTON_ICON = "/icons/Down_12x12.gif";
    private static final String UP_BUTTON_ICON = "/icons/Up_12x12.gif";
    private static final String CREATE_PROTOCOL_MESSAGE_PARAMETER = "Creation of Protocol Message Parameter";
    private IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)UMLElementTypes.OPERATION);
    protected Composite controlsSection;
    protected Button add;
    protected Button remove;
    protected Button up;
    protected Button down;
    private Parameter selectedParameter;
    private List<Parameter> selectedParameters;
    private Operation operation;
    private Consumer<? super Parameter> newParameterAction = __ -> {};
    private BiConsumer<? super Parameter, ? super Integer> movedParameterAction = (_1, _2) -> {};

    public ParameterControlEditor(Composite parent, int style, Operation operation, INattableModelManager nattableManager) {
        super(parent, style);
        this.operation = operation;
        GridLayout layout = new GridLayout(this.label == null ? 1 : 2, false);
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.createControlSelection();
        this.up = this.createButton(Activator.getDefault().getImage(UP_BUTTON_ICON), Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = this.createButton(Activator.getDefault().getImage(DOWN_BUTTON_ICON), Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.add = this.createButton(Activator.getDefault().getImage(ADD_BUTTON_ICON), Messages.MultipleValueEditor_AddElements);
        this.remove = this.createButton(Activator.getDefault().getImage(DELETE_BUTTON_ICON), Messages.MultipleValueEditor_RemoveSelectedElements);
        this.updateButtons();
    }

    protected void createControlSelection() {
        this.controlsSection = new Composite((Composite)this, 0);
        this.controlsSection.setLayout((Layout)new FillLayout());
        this.controlsSection.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
    }

    protected Button createButton(Image image, String toolTipText) {
        Button button = new Button(this.controlsSection, 8);
        button.setImage(image);
        button.addSelectionListener((SelectionListener)this);
        button.setToolTipText(toolTipText);
        return button;
    }

    public Object getEditableType() {
        return Collection.class;
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void widgetDisposed(DisposeEvent e) {
        super.widgetDisposed(e);
        this.add.dispose();
        this.up.dispose();
        this.remove.dispose();
        this.down.dispose();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.add == e.widget) {
            this.addAction();
        }
        if (this.getSelectedParameters() != null) {
            for (Parameter singleParameter : this.getSelectedParameters()) {
                this.setSelectedParameter(singleParameter);
                if (e.widget == null) continue;
                if (this.remove == e.widget) {
                    this.removeAction();
                    continue;
                }
                if (this.up == e.widget) {
                    this.upAction();
                    continue;
                }
                if (this.down != e.widget) continue;
                this.downAction();
            }
        }
        this.updateButtons();
    }

    protected void downAction() {
        Command move;
        EList ownedParameters = this.operation.getOwnedParameters();
        int indexOf = ownedParameters.indexOf(this.selectedParameter);
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)this.operation);
        if (domain != null && indexOf + 1 < ownedParameters.size() && (move = MoveCommand.create((EditingDomain)domain, (Object)this.operation, (Object)UMLPackage.Literals.BEHAVIORAL_FEATURE__OWNED_PARAMETER, (Object)this.selectedParameter, (int)(indexOf + 1))) != null) {
            move = new CommandWrapper(MOVE_DOWN, MOVE_DOWN, move);
            CommandUtil.executeCommandInStack((Command)move, (Object)this.operation);
            this.movedParameterAction.accept((Parameter)this.selectedParameter, (Integer)indexOf);
        }
    }

    protected void upAction() {
        Command move;
        int indexOf = this.operation.getOwnedParameters().indexOf((Object)this.selectedParameter);
        EditingDomain domain = EMFHelper.resolveEditingDomain((EObject)this.operation);
        if (domain != null && indexOf - 1 >= 0 && (move = MoveCommand.create((EditingDomain)domain, (Object)this.operation, (Object)UMLPackage.Literals.BEHAVIORAL_FEATURE__OWNED_PARAMETER, (Object)this.selectedParameter, (int)(indexOf - 1))) != null) {
            move = new CommandWrapper(MOVE_UP, MOVE_UP, move);
            CommandUtil.executeCommandInStack((Command)move, (Object)this.operation);
            this.movedParameterAction.accept((Parameter)this.selectedParameter, (Integer)indexOf);
        }
    }

    protected void removeAction() {
        ICommand setCommand;
        DestroyElementRequest request = new DestroyElementRequest((EObject)this.selectedParameter, false);
        if (this.getProvider() != null && (setCommand = this.getProvider().getEditCommand((IEditCommandRequest)request)) != null) {
            setCommand.setLabel(REMOVE_ELEMENT);
            Command wrapperCommand = GMFtoEMFCommandWrapper.wrap((ICommand)setCommand);
            CommandUtil.executeCommandInStack((Command)wrapperCommand, (Object)this.operation);
        }
    }

    protected void addAction() {
        ICommand createCommand;
        CreateElementRequest request = new CreateElementRequest((EObject)this.operation, (IElementType)UMLRTUIElementTypesEnumerator.PROTOCOL_MESSAGE_PARAMETER_CREATION_WITH_UI, UMLPackage.eINSTANCE.getBehavioralFeature_OwnedParameter());
        if (this.getParameterProvider() != null && (createCommand = this.getParameterProvider().getEditCommand((IEditCommandRequest)request)) != null) {
            createCommand.setLabel(CREATE_PROTOCOL_MESSAGE_PARAMETER);
            Command wrapperCommand = GMFtoEMFCommandWrapper.wrap((ICommand)createCommand);
            boolean nested = EMFHacks.isReadWriteTransactionActive((EObject)this.operation);
            if (nested) {
                EMFHacks.silently((Notifier)this.operation, op -> CommandUtil.executeCommandInStack((Command)wrapperCommand, (Object)this.operation));
            } else {
                CommandUtil.executeCommandInStack((Command)wrapperCommand, (Object)this.operation);
            }
            CommandResult result = createCommand.getCommandResult();
            if (result.getStatus().isOK() && result.getReturnValue() instanceof Parameter) {
                Parameter added = (Parameter)result.getReturnValue();
                if (nested) {
                    EMFHacks.notifyAdded((EObject)added);
                }
                this.newParameterAction.accept((Parameter)added);
            }
        }
    }

    protected IElementEditService getParameterProvider() {
        IElementEditService parameterProvider = ElementEditServiceUtils.getCommandProvider((Object)this.operation);
        return parameterProvider;
    }

    public void updateButtons() {
        if (this.selectedParameters == null || this.selectedParameters.isEmpty()) {
            this.remove.setEnabled(false);
            this.up.setEnabled(false);
            this.down.setEnabled(false);
        } else {
            this.remove.setEnabled(true);
            OptionalInt minSelectionIndex = this.selectedParameters.stream().mapToInt(this::indexOf).min();
            OptionalInt maxSelectionIndex = this.selectedParameters.stream().mapToInt(this::indexOf).max();
            this.up.setEnabled(minSelectionIndex.orElse(-1) > 0);
            this.down.setEnabled(maxSelectionIndex.orElse(Integer.MAX_VALUE) < this.operation.getOwnedParameters().size() - 1);
        }
        this.add.setEnabled(true);
    }

    private int indexOf(Parameter parameter) {
        return this.operation.getOwnedParameters().indexOf((Object)parameter);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setSelectedParameter(Parameter selectedParameter) {
        this.selectedParameter = selectedParameter;
    }

    public void setSelectedParameters(List<Parameter> selectedParameterList) {
        this.selectedParameters = selectedParameterList;
    }

    public IElementEditService getProvider() {
        return this.provider;
    }

    public void setProvider(IElementEditService provider) {
        this.provider = provider;
    }

    public List<Parameter> getSelectedParameters() {
        return this.selectedParameters;
    }

    public void onParameterAdded(Consumer<? super Parameter> newParameterAction) {
        this.newParameterAction = newParameterAction != null ? newParameterAction : __ -> {};
    }

    public void onParameterMoved(BiConsumer<? super Parameter, ? super Integer> movedParameterAction) {
        this.movedParameterAction = movedParameterAction != null ? movedParameterAction : (_1, _2) -> {};
    }
}

