/*****************************************************************************
 * Copyright (c) 2016 CEA LIST, Christian W. Damus, and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Celine JANSSENS (ALL4TEC) celine.janssens@all4tec.net - Initial API and implementation
 *   Christian W. Damus - bug 476984
 *   
 *****************************************************************************/

package org.eclipse.papyrusrt.umlrt.tooling.tables.configurations;

import static org.eclipse.papyrusrt.umlrt.tooling.ui.Messages.NoTypeForTypedElement_Label;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.gui.AbstractDialogCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.celleditor.AbstractOpenDialogCellEditorButtonAction;
import org.eclipse.papyrus.infra.nattable.celleditor.AbstractPapyrusStyledTextCellEditor;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.widgets.util.IPapyrusConverter;
import org.eclipse.papyrus.infra.widgets.util.ISetPapyrusConverter;
import org.eclipse.papyrus.uml.nattable.config.UMLSingleReferenceTextualCellEditorWithButtonConfiguration;
import org.eclipse.papyrus.uml.nattable.manager.cell.editor.UMLReferenceTextWithCompletionCellEditor;
import org.eclipse.papyrus.uml.nattable.messages.Messages;
import org.eclipse.papyrusrt.umlrt.tooling.tables.editors.cell.ParameterTypeCellEditor;

/**
 * @author Céline JANSSENS
 *
 *         Cell Editor Configuration for the Parameter Type in Papyrus RT. Parameter of RTMessage.
 */
public class ParameterTypeCellEditorConfiguration extends UMLSingleReferenceTextualCellEditorWithButtonConfiguration {

	/**
	 * {@inheritDoc}
	 * 
	 * @see org.eclipse.papyrus.uml.nattable.config.UMLSingleReferenceTextualCellEditorWithButtonConfiguration#getICellEditor(org.eclipse.papyrus.infra.nattable.model.nattable.Table, java.lang.Object,
	 *      org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider)
	 * 
	 */
	@Override
	public ICellEditor getICellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {

		super.getICellEditor(table, axisElement, elementProvider);
		AbstractPapyrusStyledTextCellEditor editor = new UMLReferenceTextWithCompletionCellEditor(table, axisElement, elementProvider);
		AbstractOpenDialogCellEditorButtonAction openDialog = getCellEditorWithDialogToOpen(axisElement, elementProvider);
		editor.setOpenDialogCellEditorButtonAction(openDialog);
		openDialog.setText("..."); //$NON-NLS-1$
		openDialog.setTooltipText(Messages.UMLReferenceCellEditorConfiguration_OpenDialogToChooseTheValue);

		return editor;
	}



	/** Cell Editor with dialogToOpen */
	private AbstractOpenDialogCellEditorButtonAction getCellEditorWithDialogToOpen(Object axisElement, ITableAxisElementProvider elementProvider) {
		AbstractOpenDialogCellEditorButtonAction openDialogConfiguration = new AbstractOpenDialogCellEditorButtonAction() {
			/**
			 * @see org.eclipse.papyrus.infra.nattable.celleditor.AbstractOpenDialogCellEditorButtonAction#createDialogCellEditor()
			 */
			@Override
			public AbstractDialogCellEditor createDialogCellEditor() {
				AbstractDialogCellEditor cellEditor = new ParameterTypeCellEditor(axisElement, elementProvider);


				return cellEditor;
			}

		};
		return openDialogConfiguration;
	}

	@Override
	public IDisplayConverter getDisplayConvert(Table table, Object axisElement, ILabelProvider provider) {
		IDisplayConverter delegate = super.getDisplayConvert(table, axisElement, provider);

		// Special conversion of null type <--> '*'
		class TypeConverter implements IDisplayConverter, ISetPapyrusConverter {

			@Override
			public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
				return delegate.displayToCanonicalValue(cell, configRegistry, displayToNull(displayValue));
			}

			@Override
			public Object displayToCanonicalValue(Object displayValue) {
				return delegate.displayToCanonicalValue(displayToNull(displayValue));
			}

			@Override
			public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
				return nullToDisplay(delegate.canonicalToDisplayValue(cell, configRegistry, canonicalValue));
			}

			@Override
			public Object canonicalToDisplayValue(Object canonicalValue) {
				return nullToDisplay(delegate.canonicalToDisplayValue(canonicalValue));
			}

			private Object displayToNull(Object displayValue) {
				Object result = displayValue;

				if ((result instanceof String) && ((String) result).trim().equals(NoTypeForTypedElement_Label)) {
					result = ""; //$NON-NLS-1$
				}

				return result;
			}

			private Object nullToDisplay(Object displayValue) {
				Object result = displayValue;

				if ((result == null) || ((result instanceof String) && ((String) result).trim().isEmpty())) {
					result = NoTypeForTypedElement_Label;
				}

				return result;
			}

			@Override
			public void setPapyrusConverter(IPapyrusConverter converter) {
				if (delegate instanceof ISetPapyrusConverter) {
					((ISetPapyrusConverter) delegate).setPapyrusConverter(converter);
				}
			}
		}

		return new TypeConverter();
	}
}
