/*****************************************************************************
 * Copyright (c) 2015, 2016 CEA LIST, Christian W. Damus, and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Onder Gurcan <onder.gurcan@cea.fr>
 * Christian W. Damus - bug 476984
 *
 *****************************************************************************/
package org.eclipse.papyrusrt.umlrt.tooling.ui.internal.types;

import java.util.List;

import org.eclipse.gmf.runtime.emf.type.core.AbstractElementTypeEnumerator;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;

import com.google.common.collect.ImmutableList;

/**
 * Enumeration of UI-specific element types, such as the "creation element types"
 * that are not intended to match existing elements by are used to invoke edit-helper
 * behaviour for specific creation scenarios.
 */
public class UMLRTUIElementTypesEnumerator extends AbstractElementTypeEnumerator implements IUMLRTUIElementTypes {

	/**
	 * Creation element-type for protocol message parameter, with prompt for type.
	 */
	public static final IHintedType PROTOCOL_MESSAGE_PARAMETER_CREATION_WITH_UI = (IHintedType) getElementType(PROTOCOL_MESSAGE_PARAMETER_CREATION_WITH_UI_ID);

	private static final List<IHintedType> types = ImmutableList.of(PROTOCOL_MESSAGE_PARAMETER_CREATION_WITH_UI);

	/**
	 * Returns all of the specific UI element types for UML-RT.
	 * 
	 * @return all of the specific UI element types for UML-RT
	 */
	public static List<IHintedType> getAllUITypes() {
		return types;
	}

}
