/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.papyrusrt.umlrt.core.utils.CapsulePartKindEnum;
import org.eclipse.papyrusrt.umlrt.core.utils.MultipleAdapter;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CapsulePartKindObservableValue
extends PapyrusObservableValue
implements IObserving {
    private static final String LABEL_MULTIPLICITY = "Set Multiplicity";
    private static final String LABEL_AGGREGATION = "Set Aggregation";
    private Property capsulePartElement;
    private AggregationKind aggregation;
    private LiteralInteger lowerValue;
    private LiteralUnlimitedNatural upperValue;
    private PartAdapter partAdapter;

    public CapsulePartKindObservableValue(EObject RTApplication, TransactionalEditingDomain domain) {
        super((EObject)UMLUtil.getBaseElement((EObject)RTApplication), UMLUtil.getBaseElement((EObject)RTApplication).eContainingFeature(), (EditingDomain)domain);
        if (RTApplication instanceof CapsulePart) {
            this.setUMLPropertiesValue();
            this.capsulePartElement = (Property)UMLUtil.getBaseElement((EObject)RTApplication);
            this.capsulePartElement.eAdapters().add((Object)this.getPartAdapter());
            this.capsulePartElement.getLowerValue().eAdapters().add((Object)this.getPartAdapter());
            this.capsulePartElement.getUpperValue().eAdapters().add((Object)this.getPartAdapter());
        }
    }

    public synchronized void dispose() {
        try {
            if (this.partAdapter != null) {
                this.partAdapter.dispose();
                this.partAdapter = null;
            }
        }
        finally {
            super.dispose();
        }
    }

    protected void setUMLPropertiesValue() {
        if (this.capsulePartElement instanceof Property) {
            this.aggregation = this.capsulePartElement.getAggregation();
            this.lowerValue = (LiteralInteger)this.capsulePartElement.getLowerValue();
            this.upperValue = (LiteralUnlimitedNatural)this.capsulePartElement.getUpperValue();
        }
    }

    protected Object doGetValue() {
        CapsulePartKindEnum kind = null;
        this.setUMLPropertiesValue();
        if (this.capsulePartElement.getLower() > 0) {
            if (AggregationKind.COMPOSITE_LITERAL.equals((Object)this.aggregation)) {
                kind = CapsulePartKindEnum.FIXED;
            }
        } else if (this.capsulePartElement.getLower() == 0) {
            if (AggregationKind.COMPOSITE_LITERAL.equals((Object)this.aggregation)) {
                kind = CapsulePartKindEnum.OPTIONAL;
            } else if (AggregationKind.SHARED_LITERAL.equals((Object)this.aggregation)) {
                kind = CapsulePartKindEnum.PLUGIN;
            }
        }
        return kind;
    }

    public Command getCommand(Object value) {
        this.setUMLPropertiesValue();
        LiteralInteger newLowerValue = UMLFactory.eINSTANCE.createLiteralInteger();
        LiteralUnlimitedNatural newUpperValue = UMLFactory.eINSTANCE.createLiteralUnlimitedNatural();
        AggregationKind newAggregation = AggregationKind.COMPOSITE_LITERAL;
        newUpperValue.setValue(this.upperValue.getValue());
        if (value instanceof CapsulePartKindEnum) {
            switch ((CapsulePartKindEnum)value) {
                case FIXED: {
                    newLowerValue.setValue(this.upperValue.getValue());
                    newAggregation = AggregationKind.COMPOSITE_LITERAL;
                    break;
                }
                case OPTIONAL: {
                    newLowerValue.setValue(0);
                    newAggregation = AggregationKind.COMPOSITE_LITERAL;
                    break;
                }
                case PLUGIN: {
                    newLowerValue.setValue(0);
                    newAggregation = AggregationKind.SHARED_LITERAL;
                    break;
                }
                default: {
                    this.lowerValue.setValue(this.upperValue.getValue());
                    newAggregation = AggregationKind.COMPOSITE_LITERAL;
                }
            }
        }
        Command command = this.getCommandForCapsulePart((ValueSpecification)newLowerValue, newAggregation);
        return command;
    }

    protected Command getCommandForCapsulePart(ValueSpecification newLowerValue, AggregationKind newAggregation) {
        CompoundCommand command = new CompoundCommand();
        command.append(this.getSetAggregationCommand(newAggregation));
        command.append(this.getSetMultiplicityCommand(newLowerValue));
        return command;
    }

    protected Command getSetMultiplicityCommand(final ValueSpecification newLowerValue) {
        RecordingCommand multiplicityCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                CapsulePartKindObservableValue.this.capsulePartElement.setLowerValue(newLowerValue);
            }

            public boolean canExecute() {
                return true;
            }

            public String getLabel() {
                return CapsulePartKindObservableValue.LABEL_MULTIPLICITY;
            }
        };
        return multiplicityCommand;
    }

    protected Command getSetAggregationCommand(final AggregationKind newAggregation) {
        RecordingCommand aggregationCommand = new RecordingCommand((TransactionalEditingDomain)this.domain){

            protected void doExecute() {
                CapsulePartKindObservableValue.this.capsulePartElement.setAggregation(newAggregation);
            }

            public boolean canExecute() {
                return true;
            }

            public String getLabel() {
                return CapsulePartKindObservableValue.LABEL_AGGREGATION;
            }
        };
        return aggregationCommand;
    }

    public Object getObserved() {
        return this.capsulePartElement;
    }

    public Object getValueType() {
        return CapsulePartKindEnum.class;
    }

    protected Adapter getMultiplicityListener() {
        return this.getPartAdapter();
    }

    protected Adapter getAggregationListener() {
        return this.getPartAdapter();
    }

    private Adapter getPartAdapter() {
        if (this.partAdapter == null) {
            this.partAdapter = new PartAdapter();
        }
        return this.partAdapter;
    }

    private class PartAdapter
    extends MultipleAdapter {
        PartAdapter() {
            super(4);
        }

        public void notifyChanged(Notification notification) {
            if (!notification.isTouch()) {
                Object notifier = notification.getNotifier();
                int type = notification.getEventType();
                Object feature = notification.getFeature();
                if (notifier == CapsulePartKindObservableValue.this.capsulePartElement && type == 1) {
                    if (feature == UMLPackage.Literals.PROPERTY__AGGREGATION) {
                        this.fireDiff(notification);
                    } else if (feature == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE || feature == UMLPackage.Literals.MULTIPLICITY_ELEMENT__UPPER_VALUE) {
                        if (notification.getOldValue() != null) {
                            ((ValueSpecification)notification.getOldValue()).eAdapters().remove((Object)this);
                        }
                        if (notification.getNewValue() != null) {
                            ((ValueSpecification)notification.getNewValue()).eAdapters().add((Object)this);
                        }
                        this.fireDiff(notification);
                    }
                } else if (notifier == CapsulePartKindObservableValue.this.capsulePartElement.getLowerValue() && type == 1) {
                    this.fireDiff(notification);
                } else if (notifier == CapsulePartKindObservableValue.this.capsulePartElement.getUpperValue() && type == 1) {
                    this.fireDiff(notification);
                }
            }
        }

        private void fireDiff(Notification notification) {
            final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
            CapsulePartKindObservableValue.this.getRealm().exec(new Runnable(){

                @Override
                public void run() {
                    CapsulePartKindObservableValue.this.fireValueChange(diff);
                }
            });
        }
    }
}

