/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.widgets;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrusrt.umlrt.core.utils.ProtocolUtils;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.tooling.ui.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.AnyReceiveEvent;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.util.UMLUtil;

public class EventSelectionDialog
extends ReferenceDialog {
    protected EList<Package> protocols;
    protected EList<Package> conjProtocols;
    protected Trigger trigger = null;
    protected boolean errorShown = false;

    public EventSelectionDialog(Composite parent, int style) {
        super(parent, style);
    }

    protected void doBinding() {
        IObservableValue inputObservableValue;
        this.editor.setLabelProvider((ILabelProvider)new EventLabelProvider());
        this.editor.setDirectCreation(this.input.getDirectCreation(this.propertyPath));
        this.editor.setMandatory(this.input.isMandatory(this.propertyPath));
        ModelElement triggerElement = this.input.getModelElement(this.propertyPath);
        EObject triggerEObj = ((UMLModelElement)triggerElement).getSource();
        this.trigger = triggerEObj instanceof Trigger ? (Trigger)triggerEObj : null;
        this.updateProtocols();
        this.editor.setContentProvider((IStaticContentProvider)new EventContentProvider());
        if (this.valueEditor != null && (inputObservableValue = this.getInputObservableValue()) != null) {
            this.valueEditor.setStrategies();
            IValidator modelVal = this.getValidator();
            if (modelVal != null) {
                this.valueEditor.setModelValidator(modelVal);
            }
            this.valueEditor.setModelObservable(inputObservableValue);
        }
    }

    protected void updateProtocols() {
        this.protocols = new UniqueEList();
        this.conjProtocols = new UniqueEList();
        if (this.trigger != null) {
            for (Port port : this.trigger.getPorts()) {
                Package protocol;
                if (port.getType() == null || (protocol = port.getType().getNearestPackage()) == null) continue;
                if (port.isConjugated()) {
                    this.conjProtocols.add((Object)protocol);
                    continue;
                }
                this.protocols.add((Object)protocol);
            }
        }
    }

    protected void addCallEvents(ArrayList<Event> events, Package protocol) {
        boolean normal = this.protocols.contains((Object)protocol);
        boolean conjugated = this.conjProtocols.contains((Object)protocol);
        for (PackageableElement pe : protocol.getPackagedElements()) {
            CallEvent callEvent;
            Interface intf;
            RTMessageSet rtMessageSet;
            RTMessageKind kind;
            if (!(pe instanceof CallEvent) || (kind = (rtMessageSet = (RTMessageSet)UMLUtil.getStereotypeApplication((Element)(intf = (callEvent = (CallEvent)pe).getOperation().getInterface()), RTMessageSet.class)).getRtMsgKind()) != RTMessageKind.IN_OUT && (kind != RTMessageKind.IN || conjugated) && (kind != RTMessageKind.OUT || normal)) continue;
            events.add((Event)callEvent);
        }
    }

    protected EList<Package> getDirectProtocols() {
        UniqueEList directProtocols = new UniqueEList();
        directProtocols.addAll(this.protocols);
        directProtocols.addAll(this.conjProtocols);
        return directProtocols;
    }

    protected static void addAnyEvent(ArrayList<Event> events, boolean conjugated, Package protocolContainer) {
        for (PackageableElement pe : protocolContainer.getPackagedElements()) {
            if (!(pe instanceof AnyReceiveEvent)) continue;
            events.add((Event)((AnyReceiveEvent)pe));
        }
    }

    public Package getBaseProtocol() {
        if (this.trigger != null) {
            Package root = PackageUtil.getRootPackage((Element)this.trigger);
            Package baseProtocol = ProtocolUtils.getBaseProtocol((Element)root);
            if (baseProtocol != null) {
                return baseProtocol;
            }
            if (!this.errorShown) {
                this.errorShown = true;
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.EventSelectionDialog_BaseProtocolNotFound_Title, (String)Messages.EventSelectionDialog_BaseProtocolNotFound_Message);
            }
        }
        return null;
    }

    protected class EventContentProvider
    implements IStaticContentProvider,
    ITreeContentProvider {
        protected EventContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getElements();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            EventSelectionDialog.this.updateProtocols();
            if (viewer instanceof TreeViewer) {
                final TreeViewer treeViewer = (TreeViewer)viewer;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        treeViewer.expandAll();
                    }
                });
            }
        }

        public Object[] getElements() {
            ArrayList<Event> events = new ArrayList<Event>();
            if (EventSelectionDialog.this.protocols.size() > 0) {
                EventSelectionDialog.addAnyEvent(events, false, (Package)EventSelectionDialog.this.protocols.get(0));
            } else if (EventSelectionDialog.this.conjProtocols.size() > 0) {
                EventSelectionDialog.addAnyEvent(events, true, (Package)EventSelectionDialog.this.conjProtocols.get(0));
            }
            return events.toArray();
        }

        public Object[] getChildren(Object parent) {
            ArrayList<Event> events = new ArrayList<Event>();
            UniqueEList allProtocols = new UniqueEList();
            EList<Package> directProtocols = EventSelectionDialog.this.getDirectProtocols();
            for (Package protocol : directProtocols) {
                allProtocols.addAll((Collection)ProtocolUtils.getAllProtocols((Package)protocol));
            }
            for (Package protocol : allProtocols) {
                if (!ProtocolUtils.isCommonProtocol(directProtocols, (Package)protocol)) continue;
                EventSelectionDialog.this.addCallEvents(events, protocol);
            }
            return events.toArray();
        }

        public Object getParent(Object parent) {
            return null;
        }

        public boolean hasChildren(Object event) {
            return event instanceof AnyReceiveEvent;
        }
    }

    protected class EventLabelProvider
    extends DelegatingLabelProvider {
        public EventLabelProvider() {
            super(EventSelectionDialog.this.input.getLabelProvider(EventSelectionDialog.this.propertyPath));
        }

        public Image getImage(Object element) {
            if (element instanceof AnyReceiveEvent) {
                return null;
            }
            return super.getImage(element);
        }

        protected Image customGetImage(Object element) {
            if (element instanceof CallEvent) {
                CallEvent ce = (CallEvent)element;
                return this.getImage(ce.getOperation());
            }
            return null;
        }
    }
}

