/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.external.predefined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Capsule;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.CapsulePart;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Protocol;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.ProtocolContainer;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTConnector;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageKind;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTMessageSet;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTPort;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.RTRedefinedElement;
import org.eclipse.papyrusrt.xtumlrt.util.UML2Util;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public final class UMLRTProfileUtil {
    private static final String UML_REAL_TIME_CAPSULE = "UMLRealTime::Capsule";
    private static final String UML_REAL_TIME_CAPSULE_PART = "UMLRealTime::CapsulePart";
    private static final String UML_REAL_TIME_PROTOCOL = "UMLRealTime::Protocol";
    private static final String UML_REAL_TIME_RT_PORT = "UMLRealTime::RTPort";
    private static final String UML_REAL_TIME_RT_CONNECTOR = "UMLRealTime::RTConnector";
    private static final String UML_REAL_TIME_PROTOCOL_CONTAINER = "UMLRealTime::ProtocolContainer";
    private static final String UML_REAL_TIME_RT_REDEFINED_ELEMENT = "UMLRealTime::RTRedefinedElement";
    private static final String UML_REAL_TIME_RT_MESSAGE_SET = "UMLRealTime::RTMessageSet";

    private UMLRTProfileUtil() {
    }

    public static boolean isCapsule(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_CAPSULE);
        return s != null && el.isStereotypeApplied(s);
    }

    public static Capsule getCapsule(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_CAPSULE);
        return s == null ? null : (Capsule)el.getStereotypeApplication(s);
    }

    public static boolean isCapsulePart(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_CAPSULE_PART);
        return s != null && el.isStereotypeApplied(s);
    }

    public static CapsulePart getCapsulePart(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_CAPSULE_PART);
        return s == null ? null : (CapsulePart)el.getStereotypeApplication(s);
    }

    public static boolean isProtocol(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_PROTOCOL);
        return s != null && el.isStereotypeApplied(s);
    }

    public static Protocol getProtocol(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_PROTOCOL);
        return s == null ? null : (Protocol)el.getStereotypeApplication(s);
    }

    public static Collaboration getProtocolCollaboration(Package protocolPackage) {
        Collaboration collaboration = null;
        if (UMLRTProfileUtil.isProtocolContainer((Element)protocolPackage)) {
            for (Element element : protocolPackage.getOwnedElements()) {
                if (!(element instanceof Collaboration) || !UMLRTProfileUtil.isProtocol(element)) continue;
                collaboration = (Collaboration)element;
                break;
            }
        }
        return collaboration;
    }

    public static boolean isRTPort(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_RT_PORT);
        return s != null && el.isStereotypeApplied(s);
    }

    public static RTPort getRTPort(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_RT_PORT);
        return s == null ? null : (RTPort)el.getStereotypeApplication(s);
    }

    public static boolean isRTConnector(Connector connector) {
        Stereotype s = connector.getApplicableStereotype(UML_REAL_TIME_RT_CONNECTOR);
        return s != null && connector.isStereotypeApplied(s);
    }

    public static RTConnector getRTConnector(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_RT_CONNECTOR);
        return s == null ? null : (RTConnector)el.getStereotypeApplication(s);
    }

    public static boolean isProtocolContainer(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_PROTOCOL_CONTAINER);
        return s != null && el.isStereotypeApplied(s);
    }

    public static ProtocolContainer getProtocolContainer(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_PROTOCOL_CONTAINER);
        return s == null ? null : (ProtocolContainer)el.getStereotypeApplication(s);
    }

    public static boolean isRTRedefinedElement(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_RT_REDEFINED_ELEMENT);
        return s != null && el.isStereotypeApplied(s);
    }

    public static RTRedefinedElement getRTRedefinedElement(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_RT_REDEFINED_ELEMENT);
        return s == null ? null : (RTRedefinedElement)el.getStereotypeApplication(s);
    }

    public static boolean isRTMessageSet(Element el) {
        Stereotype s = el.getApplicableStereotype(UML_REAL_TIME_RT_MESSAGE_SET);
        return s != null && el.isStereotypeApplied(s);
    }

    public static RTMessageSet getRTMessageSet(Element el) {
        Stereotype s = el.getAppliedStereotype(UML_REAL_TIME_RT_MESSAGE_SET);
        return s == null ? null : (RTMessageSet)el.getStereotypeApplication(s);
    }

    private static Iterable<Operation> getProtocolMessagesFromRTMessageSets(Iterable<Interface> interfaces, RTMessageKind messageKind, boolean includeInOut) {
        TreeSet<Operation> operations = new TreeSet<Operation>((Comparator<Operation>)new UML2Util.NameComparator());
        if (interfaces != null) {
            for (Interface iface : interfaces) {
                RTMessageKind kind;
                RTMessageSet rtMessageSet = UMLRTProfileUtil.getRTMessageSet((Element)iface);
                if (rtMessageSet == null || (kind = rtMessageSet.getRtMsgKind()) != messageKind && (!includeInOut || kind != RTMessageKind.IN_OUT)) continue;
                operations.addAll((Collection<Operation>)iface.getOwnedOperations());
            }
        }
        return operations;
    }

    public static Iterable<Operation> getProtocolMessages(Collaboration collaboration, RTMessageKind kind) {
        Iterable<Operation> messages = null;
        switch (kind) {
            case IN: {
                messages = UMLRTProfileUtil.getInProtocolMessages(collaboration, false);
                break;
            }
            case OUT: {
                messages = UMLRTProfileUtil.getOutProtocolMessages(collaboration, false);
                break;
            }
            case IN_OUT: {
                messages = UMLRTProfileUtil.getInOutProtocolMessages(collaboration);
                break;
            }
        }
        return messages;
    }

    public static Iterable<Operation> getInProtocolMessages(Collaboration collaboration, boolean includeInOut) {
        return UMLRTProfileUtil.getProtocolMessagesFromRTMessageSets((Iterable<Interface>)collaboration.directlyRealizedInterfaces(), RTMessageKind.IN, true);
    }

    public static Iterable<Operation> getOutProtocolMessages(Collaboration collaboration, boolean includeInOut) {
        return UMLRTProfileUtil.getProtocolMessagesFromRTMessageSets((Iterable<Interface>)collaboration.directlyUsedInterfaces(), RTMessageKind.OUT, true);
    }

    public static Iterable<Operation> getInOutProtocolMessages(Collaboration collaboration) {
        return UMLRTProfileUtil.getProtocolMessagesFromRTMessageSets((Iterable<Interface>)collaboration.directlyRealizedInterfaces(), RTMessageKind.IN_OUT, false);
    }

    public static boolean isSignal(Element el) {
        boolean result = false;
        if (el != null && el instanceof Operation) {
            Operation op = (Operation)el;
            Interface iface = op.getInterface();
            result = iface != null && UMLRTProfileUtil.isRTMessageSet((Element)iface);
        }
        return result;
    }

    public static Package getProtocol(Port umlPort) {
        Package pkg;
        Package protocolContainer = null;
        Type type = umlPort.getType();
        if (type != null && (pkg = type.getPackage()) != null) {
            protocolContainer = UMLRTProfileUtil.isProtocolContainer((Element)pkg) ? pkg : null;
        }
        return protocolContainer;
    }

    public static Package getProtocol(Operation umlOperation) {
        Package pkg;
        Package protocolContainer = null;
        if (UMLRTProfileUtil.isSignal((Element)umlOperation) && UMLRTProfileUtil.isProtocolContainer((Element)(pkg = umlOperation.getNearestPackage()))) {
            protocolContainer = pkg;
        }
        return protocolContainer;
    }

    public static Iterable<Property> getCapsuleParts(EncapsulatedClassifier classifier) {
        TreeSet<Property> parts = new TreeSet<Property>((Comparator<Property>)new UML2Util.NameComparator());
        for (Property attr : classifier.getOwnedAttributes()) {
            if (!UMLRTProfileUtil.isCapsulePart((Element)attr)) continue;
            parts.add(attr);
        }
        return parts;
    }

    public static Iterable<Port> getRTPorts(EncapsulatedClassifier classifier) {
        TreeSet<Port> ports = new TreeSet<Port>((Comparator<Port>)new UML2Util.NameComparator());
        for (Port port : classifier.getOwnedPorts()) {
            if (!UMLRTProfileUtil.isRTPort((Element)port) || UMLRTProfileUtil.getProtocol(port) == null) continue;
            ports.add(port);
        }
        return ports;
    }

    public static Iterable<Port> getAllRTPorts(Class klass) {
        TreeSet<Port> allPorts = new TreeSet<Port>((Comparator<Port>)new UML2Util.NameComparator());
        if (klass != null) {
            for (Port p : UMLRTProfileUtil.getRTPorts((EncapsulatedClassifier)klass)) {
                allPorts.add(p);
            }
            Class parent = UMLRTProfileUtil.getBaseRTCapsule(klass);
            if (parent != null) {
                for (Port p : UMLRTProfileUtil.getAllRTPorts(parent)) {
                    if (UMLRTProfileUtil.redefines(klass, p)) continue;
                    allPorts.add(p);
                }
            }
        }
        return allPorts;
    }

    public static Iterable<Connector> getRTConnectors(EncapsulatedClassifier classifier) {
        TreeSet<Connector> connectors = new TreeSet<Connector>((Comparator<Connector>)new UML2Util.NameComparator());
        for (Connector connector : classifier.getOwnedConnectors()) {
            if (!UMLRTProfileUtil.isRTConnector(connector)) continue;
            connectors.add(connector);
        }
        return connectors;
    }

    public static Iterable<Connector> getAllRTConnectors(Class klass) {
        TreeSet<Connector> allConnectors = new TreeSet<Connector>((Comparator<Connector>)new UML2Util.NameComparator());
        if (klass != null) {
            for (Connector c : UMLRTProfileUtil.getRTConnectors((EncapsulatedClassifier)klass)) {
                allConnectors.add(c);
            }
            Class parent = UMLRTProfileUtil.getBaseRTCapsule(klass);
            if (parent != null) {
                for (Connector c : UMLRTProfileUtil.getAllRTConnectors(parent)) {
                    if (UMLRTProfileUtil.redefines(klass, c)) continue;
                    allConnectors.add(c);
                }
            }
        }
        return allConnectors;
    }

    private static Class getBaseRTCapsule(Class klass) {
        Class parent = null;
        if (klass != null && !klass.getSuperClasses().isEmpty()) {
            for (Class kls : klass.getSuperClasses()) {
                if (!UMLRTProfileUtil.isCapsule((Element)kls)) continue;
                parent = kls;
                break;
            }
        }
        return parent;
    }

    private static boolean redefines(Class klass, Port port) {
        boolean result = false;
        if (port != null) {
            for (Port p : UMLRTProfileUtil.getRedefinedPorts(klass)) {
                if (p != port && !port.equals(p)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static boolean redefines(Class klass, Connector connector) {
        boolean result = false;
        if (connector != null) {
            for (Connector c : UMLRTProfileUtil.getRedefinedConnectors(klass)) {
                if (c != connector && !connector.equals(c)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private static Iterable<Port> getRedefinedPorts(Class klass) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Port p : UMLRTProfileUtil.getPortRedefinitions(klass)) {
            Port redefined = (Port)p.getRedefinedPorts().get(0);
            ports.add(redefined);
        }
        return ports;
    }

    private static Iterable<Port> getPortRedefinitions(Class klass) {
        ArrayList<Port> ports = new ArrayList<Port>();
        for (Port p : UMLRTProfileUtil.getRTPorts((EncapsulatedClassifier)klass)) {
            if (p.getRedefinedPorts() == null || p.getRedefinedPorts().isEmpty()) continue;
            ports.add(p);
        }
        return ports;
    }

    private static Iterable<Connector> getRedefinedConnectors(Class klass) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Connector c : UMLRTProfileUtil.getConnectorRedefinitions(klass)) {
            Connector redefined = (Connector)c.getRedefinedConnectors().get(0);
            connectors.add(redefined);
        }
        return connectors;
    }

    private static Iterable<Connector> getConnectorRedefinitions(Class klass) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (Connector c : UMLRTProfileUtil.getRTConnectors((EncapsulatedClassifier)klass)) {
            if (c.getRedefinedConnectors() == null || c.getRedefinedConnectors().isEmpty()) continue;
            connectors.add(c);
        }
        return connectors;
    }
}

