/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.trans.from.uml;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrusrt.xtumlrt.common.Annotation;
import org.eclipse.papyrusrt.xtumlrt.common.AnnotationParameter;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GenerationProperties {
    private static final HashMap<CommonElement, EList<EObject>> genProperties = new HashMap();

    public static void setGenProperties(Element umlElement, CommonElement element) {
        if (umlElement == null || element == null || umlElement.getApplicableStereotypes() == null) {
            return;
        }
        Object _xifexpression = null;
        EList _stereotypeApplications = umlElement.getStereotypeApplications();
        boolean _tripleNotEquals = _stereotypeApplications != null;
        _xifexpression = _tripleNotEquals ? umlElement.getStereotypeApplications() : new BasicEList();
        EList stereotypeApplications = _xifexpression;
        genProperties.put(element, (EList<EObject>)stereotypeApplications);
    }

    public static EList<EObject> getAllGenProperties(CommonElement element) {
        return genProperties.get(element);
    }

    protected static Object _getProperty(CommonElement element, String stereotype, String property) {
        if (element == null || stereotype == null || property == null) {
            return null;
        }
        Object propertyValue = null;
        if (element instanceof NamedElement) {
            Object _findProperty;
            EList annotations = ((NamedElement)element).getAnnotations();
            propertyValue = _findProperty = GenerationProperties.findProperty(stereotype, property, (Iterable<? extends EObject>)annotations);
        }
        if (propertyValue == null && genProperties.containsKey(element)) {
            Object _findProperty_1;
            EList<EObject> elemStereotypes = genProperties.get(element);
            propertyValue = _findProperty_1 = GenerationProperties.findProperty(stereotype, property, elemStereotypes);
        }
        return propertyValue;
    }

    protected static Object _findProperty(final String stereotype, String property, Iterable<? extends EObject> annotations) {
        Object _xifexpression = null;
        if (annotations != null && !IterableExtensions.isEmpty(annotations)) {
            Object _xblockexpression = null;
            Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                public Boolean apply(EObject it) {
                    String _annotationName = GenerationProperties.getAnnotationName(it);
                    return Objects.equal((Object)_annotationName, (Object)stereotype);
                }
            };
            EObject annotation = (EObject)IterableExtensions.findFirst(annotations, (Functions.Function1)_function);
            Object _xifexpression_1 = null;
            if (annotation != null) {
                _xifexpression_1 = GenerationProperties.getAnnotationProperty(annotation, property);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected static Object _getProperty(CommonElement element, Collection<String> stereotypes, String property) {
        if (stereotypes == null || property == null) {
            return null;
        }
        Object propertyValue = null;
        if (element instanceof NamedElement) {
            Object _findProperty;
            EList annotations = ((NamedElement)element).getAnnotations();
            propertyValue = _findProperty = GenerationProperties.findProperty(stereotypes, property, (Iterable<? extends EObject>)annotations);
        }
        if (propertyValue == null && genProperties.containsKey(element)) {
            Object _findProperty_1;
            EList<EObject> elemStereotypes = genProperties.get(element);
            propertyValue = _findProperty_1 = GenerationProperties.findProperty(stereotypes, property, elemStereotypes);
        }
        return propertyValue;
    }

    protected static Object _findProperty(final Collection<String> stereotypes, String property, Iterable<? extends EObject> annotations) {
        Object _xifexpression = null;
        if (annotations != null && !IterableExtensions.isEmpty(annotations)) {
            Object _xblockexpression = null;
            Functions.Function1<EObject, Boolean> _function = new Functions.Function1<EObject, Boolean>(){

                public Boolean apply(EObject it) {
                    String _annotationName = GenerationProperties.getAnnotationName(it);
                    return stereotypes.contains(_annotationName);
                }
            };
            EObject annotation = (EObject)IterableExtensions.findFirst(annotations, (Functions.Function1)_function);
            Object _xifexpression_1 = null;
            if (annotation != null) {
                _xifexpression_1 = GenerationProperties.getAnnotationProperty(annotation, property);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected static String _getAnnotationName(Annotation annotation) {
        return annotation.getName();
    }

    protected static String _getAnnotationName(Stereotype stereotype) {
        EClass _eClass = stereotype.eClass();
        return _eClass.getName();
    }

    protected static String _getAnnotationName(EObject eobj) {
        EClass _eClass = eobj.eClass();
        return _eClass.getName();
    }

    protected static Object _getAnnotationProperty(Annotation annotation, final String property) {
        String _xblockexpression = null;
        EList _parameters = null;
        if (annotation != null) {
            _parameters = annotation.getParameters();
        }
        AnnotationParameter _findFirst = null;
        if (_parameters != null) {
            Functions.Function1<AnnotationParameter, Boolean> _function = new Functions.Function1<AnnotationParameter, Boolean>(){

                public Boolean apply(AnnotationParameter it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)property);
                }
            };
            _findFirst = (AnnotationParameter)IterableExtensions.findFirst((Iterable)_parameters, (Functions.Function1)_function);
        }
        AnnotationParameter param = _findFirst;
        String _value = null;
        if (param != null) {
            _value = param.getValue();
        }
        _xblockexpression = _value;
        return _xblockexpression;
    }

    protected static Object _getAnnotationProperty(Stereotype stereotype, final String property) {
        Object _xblockexpression = null;
        EClass _eClass = null;
        if (stereotype != null) {
            _eClass = stereotype.eClass();
        }
        EList _eAllStructuralFeatures = null;
        if (_eClass != null) {
            _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
        }
        EStructuralFeature _findFirst = null;
        if (_eAllStructuralFeatures != null) {
            Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)property);
                }
            };
            _findFirst = (EStructuralFeature)IterableExtensions.findFirst((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        }
        EStructuralFeature feature = _findFirst;
        Object _xifexpression = null;
        if (feature != null) {
            Object _eGet = null;
            if (stereotype != null) {
                _eGet = stereotype.eGet(feature);
            }
            _xifexpression = _eGet;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected static Object _getAnnotationProperty(EObject eobj, final String property) {
        Object _xblockexpression = null;
        EClass _eClass = null;
        if (eobj != null) {
            _eClass = eobj.eClass();
        }
        EList _eAllStructuralFeatures = null;
        if (_eClass != null) {
            _eAllStructuralFeatures = _eClass.getEAllStructuralFeatures();
        }
        EStructuralFeature _findFirst = null;
        if (_eAllStructuralFeatures != null) {
            Functions.Function1<EStructuralFeature, Boolean> _function = new Functions.Function1<EStructuralFeature, Boolean>(){

                public Boolean apply(EStructuralFeature it) {
                    String _name = it.getName();
                    return Objects.equal((Object)_name, (Object)property);
                }
            };
            _findFirst = (EStructuralFeature)IterableExtensions.findFirst((Iterable)_eAllStructuralFeatures, (Functions.Function1)_function);
        }
        EStructuralFeature feature = _findFirst;
        Object _xifexpression = null;
        if (feature != null) {
            Object _eGet = null;
            if (eobj != null) {
                _eGet = eobj.eGet(feature);
            }
            _xifexpression = _eGet;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Object getProperty(CommonElement element, Object stereotype, String property) {
        if (stereotype instanceof String) {
            return GenerationProperties._getProperty(element, (String)stereotype, property);
        }
        if (stereotype instanceof Collection) {
            return GenerationProperties._getProperty(element, (Collection)stereotype, property);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element, stereotype, property).toString());
    }

    protected static Object findProperty(Object stereotype, String property, Iterable<? extends EObject> annotations) {
        if (stereotype instanceof String) {
            return GenerationProperties._findProperty((String)stereotype, property, annotations);
        }
        if (stereotype instanceof Collection) {
            return GenerationProperties._findProperty((Collection)stereotype, property, annotations);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stereotype, property, annotations).toString());
    }

    protected static String getAnnotationName(EObject stereotype) {
        if (stereotype instanceof Stereotype) {
            return GenerationProperties._getAnnotationName((Stereotype)stereotype);
        }
        if (stereotype instanceof Annotation) {
            return GenerationProperties._getAnnotationName((Annotation)stereotype);
        }
        if (stereotype != null) {
            return GenerationProperties._getAnnotationName(stereotype);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stereotype).toString());
    }

    protected static Object getAnnotationProperty(EObject stereotype, String property) {
        if (stereotype instanceof Stereotype) {
            return GenerationProperties._getAnnotationProperty((Stereotype)stereotype, property);
        }
        if (stereotype instanceof Annotation) {
            return GenerationProperties._getAnnotationProperty((Annotation)stereotype, property);
        }
        if (stereotype != null) {
            return GenerationProperties._getAnnotationProperty(stereotype, property);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(stereotype, property).toString());
    }
}

