/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.xtumlrt.common.Behaviour;
import org.eclipse.papyrusrt.xtumlrt.common.Capsule;
import org.eclipse.papyrusrt.xtumlrt.common.CapsulePart;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Connector;
import org.eclipse.papyrusrt.xtumlrt.common.Generalization;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.common.MultiplicityElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.common.Package;
import org.eclipse.papyrusrt.xtumlrt.common.Port;
import org.eclipse.papyrusrt.xtumlrt.common.Protocol;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeature;
import org.eclipse.papyrusrt.xtumlrt.common.ProtocolBehaviourFeatureKind;
import org.eclipse.papyrusrt.xtumlrt.common.RedefinableElement;
import org.eclipse.papyrusrt.xtumlrt.common.Signal;
import org.eclipse.papyrusrt.xtumlrt.common.StructuredType;
import org.eclipse.papyrusrt.xtumlrt.umlrt.PortKind;
import org.eclipse.papyrusrt.xtumlrt.umlrt.PortRegistration;
import org.eclipse.papyrusrt.xtumlrt.umlrt.RTPort;
import org.eclipse.papyrusrt.xtumlrt.util.QualifiedNames;
import org.eclipse.papyrusrt.xtumlrt.util.UndefinedValueException;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class XTUMLRTUtil {
    public static Behaviour getActualBehaviour(Capsule capsule) {
        Behaviour _xblockexpression = null;
        Behaviour behaviour = null;
        if (capsule != null) {
            boolean _tripleNotEquals;
            Behaviour _behaviour = capsule.getBehaviour();
            boolean bl = _tripleNotEquals = _behaviour != null;
            if (_tripleNotEquals) {
                Behaviour _behaviour_1;
                behaviour = _behaviour_1 = capsule.getBehaviour();
            } else if (capsule.getRedefines() != null && capsule.getRedefines() instanceof Capsule) {
                Behaviour _actualBehaviour;
                RedefinableElement _redefines = capsule.getRedefines();
                behaviour = _actualBehaviour = XTUMLRTUtil.getActualBehaviour((Capsule)_redefines);
            }
        }
        _xblockexpression = behaviour;
        return _xblockexpression;
    }

    protected static Iterable<Capsule> _getAllCapsules(Model model) {
        LinkedHashSet<Capsule> _xblockexpression = null;
        LinkedHashSet<Capsule> set = new LinkedHashSet<Capsule>();
        EList _entities = model.getEntities();
        Iterable _filter = Iterables.filter((Iterable)_entities, Capsule.class);
        Iterables.addAll(set, (Iterable)_filter);
        EList _packages = model.getPackages();
        for (Package pkg : _packages) {
            Iterable<Capsule> _allCapsules = XTUMLRTUtil.getAllCapsules((EObject)pkg);
            Iterables.addAll(set, _allCapsules);
        }
        _xblockexpression = set;
        return _xblockexpression;
    }

    protected static Iterable<Capsule> _getAllCapsules(Package packge) {
        LinkedHashSet<Capsule> _xblockexpression = null;
        LinkedHashSet<Capsule> set = new LinkedHashSet<Capsule>();
        EList _entities = packge.getEntities();
        Iterable _filter = Iterables.filter((Iterable)_entities, Capsule.class);
        Iterables.addAll(set, (Iterable)_filter);
        _xblockexpression = set;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getAllCapsuleParts(final Capsule capsule) {
        LinkedHashSet<CapsulePart> _xblockexpression = null;
        LinkedHashSet<CapsulePart> allParts = new LinkedHashSet<CapsulePart>();
        if (capsule != null) {
            EList _parts = capsule.getParts();
            allParts.addAll((Collection<CapsulePart>)_parts);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<CapsulePart> _allCapsuleParts = XTUMLRTUtil.getAllCapsuleParts(parent);
                Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

                    public Boolean apply(CapsulePart it) {
                        boolean _redefines = XTUMLRTUtil.redefines((RedefinableElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allCapsuleParts, (Functions.Function1)_function);
                Iterables.addAll(allParts, (Iterable)_filter);
            }
        }
        _xblockexpression = allParts;
        return _xblockexpression;
    }

    public static Iterable<Connector> getAllConnectors(Capsule capsule) {
        LinkedHashSet<Connector> _xblockexpression = null;
        LinkedHashSet<Connector> allConnectors = new LinkedHashSet<Connector>();
        if (capsule != null) {
            EList _connectors = capsule.getConnectors();
            allConnectors.addAll((Collection<Connector>)_connectors);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Connector> _allConnectors = XTUMLRTUtil.getAllConnectors(parent);
                Iterables.addAll(allConnectors, _allConnectors);
            }
        }
        _xblockexpression = allConnectors;
        return _xblockexpression;
    }

    public static Iterable<Port> getAllRTPorts(final Capsule capsule) {
        LinkedHashSet<Port> _xblockexpression = null;
        LinkedHashSet<Port> allPorts = new LinkedHashSet<Port>();
        if (capsule != null) {
            Iterable<Port> _rTPorts = XTUMLRTUtil.getRTPorts(capsule);
            Iterables.addAll(allPorts, _rTPorts);
            RedefinableElement parentElement = capsule.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Capsule parent = (Capsule)parentElement;
                Iterable<Port> _allRTPorts = XTUMLRTUtil.getAllRTPorts(parent);
                Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

                    public Boolean apply(Port it) {
                        boolean _redefines = XTUMLRTUtil.redefines((RedefinableElement)capsule, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allRTPorts, (Functions.Function1)_function);
                Iterables.addAll(allPorts, (Iterable)_filter);
            }
        }
        _xblockexpression = allPorts;
        return _xblockexpression;
    }

    public static Iterable<Signal> getAllSignals(final Protocol protocol) {
        LinkedHashSet<Signal> _xblockexpression = null;
        LinkedHashSet<Signal> allSignals = new LinkedHashSet<Signal>();
        if (protocol != null) {
            Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
            Iterables.addAll(allSignals, _signals);
            RedefinableElement parentElement = protocol.getRedefines();
            if (parentElement != null && parentElement instanceof Capsule) {
                Protocol parent = (Protocol)parentElement;
                Iterable<Signal> _allSignals = XTUMLRTUtil.getAllSignals(parent);
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it) {
                        boolean _redefines = XTUMLRTUtil.redefines((RedefinableElement)protocol, (RedefinableElement)it);
                        return !_redefines;
                    }
                };
                Iterable _filter = IterableExtensions.filter(_allSignals, (Functions.Function1)_function);
                Iterables.addAll(allSignals, (Iterable)_filter);
            }
        }
        _xblockexpression = allSignals;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getCapsuleParts(Capsule capsule) {
        LinkedHashSet<CapsulePart> _xblockexpression = null;
        LinkedHashSet<CapsulePart> parts = new LinkedHashSet<CapsulePart>();
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                Capsule _type = it.getType();
                return _type != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
        Iterables.addAll(parts, (Iterable)_filter);
        _xblockexpression = parts;
        return _xblockexpression;
    }

    public static int getBound(MultiplicityElement element) throws UndefinedValueException {
        String lowerBoundSpec = element.getLowerBound();
        String upperBoundSpec = element.getUpperBound();
        int lowerBound = -1;
        int upperBound = -1;
        int bound = -1;
        boolean parsedLowerBound = true;
        try {
            int _parseInt;
            bound = lowerBound = (_parseInt = Integer.parseInt(lowerBoundSpec));
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException cfr_ignored_0 = (NumberFormatException)_t;
                parsedLowerBound = false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            int _parseInt_1;
            bound = upperBound = (_parseInt_1 = Integer.parseInt(upperBoundSpec));
            if (parsedLowerBound && lowerBound > upperBound) {
                bound = lowerBound;
            }
            return bound;
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof NumberFormatException) {
                NumberFormatException cfr_ignored_1 = (NumberFormatException)_t_1;
                throw new UndefinedValueException(upperBoundSpec);
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
    }

    public static <T extends MultiplicityElement & NamedElement> String getBoundString(T element) {
        String lowerBoundSpec = element.getLowerBound();
        String upperBoundSpec = element.getUpperBound();
        int lowerBound = -1;
        int upperBound = -1;
        int bound = 0;
        boolean parsedLowerBound = true;
        try {
            int _parseInt;
            lowerBound = _parseInt = Integer.parseInt(lowerBoundSpec);
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException cfr_ignored_0 = (NumberFormatException)_t;
                parsedLowerBound = false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        try {
            int _parseInt_1;
            bound = upperBound = (_parseInt_1 = Integer.parseInt(upperBoundSpec));
            if (parsedLowerBound && lowerBound > upperBound) {
                bound = lowerBound;
            }
            return Integer.valueOf(bound).toString();
        }
        catch (Throwable _t_1) {
            if (_t_1 instanceof NumberFormatException) {
                NumberFormatException cfr_ignored_1 = (NumberFormatException)_t_1;
                return upperBoundSpec;
            }
            throw Exceptions.sneakyThrow((Throwable)_t_1);
        }
    }

    public static Iterable<Signal> getInSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && Objects.equal((Object)it.getKind(), (Object)ProtocolBehaviourFeatureKind.IN);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static Iterable<Signal> getInOutSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && Objects.equal((Object)it.getKind(), (Object)ProtocolBehaviourFeatureKind.INOUT);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static <T extends MultiplicityElement & NamedElement> int getLowerBound(T element) {
        String boundSpec = element.getLowerBound();
        try {
            int bound = Integer.parseInt(boundSpec);
            if (bound < 0) {
                String _fullName = QualifiedNames.fullName(element);
                String _plus = "Lower bound must be specified for " + _fullName;
                throw new RuntimeException(_plus);
            }
            return bound;
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException cfr_ignored_0 = (NumberFormatException)_t;
                String _fullName_1 = QualifiedNames.fullName(element);
                String _plus_1 = "Value of lower bound specified for " + _fullName_1;
                String _plus_2 = String.valueOf(_plus_1) + " could not be determined.";
                throw new RuntimeException(_plus_2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static Iterable<Signal> getOutSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal && Objects.equal((Object)it.getKind(), (Object)ProtocolBehaviourFeatureKind.OUT);
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static NamedElement getOwner(CommonElement element) {
        boolean _tripleEquals;
        NamedElement _xifexpression = null;
        EObject _eContainer = element.eContainer();
        boolean bl = _tripleEquals = _eContainer == null;
        if (_tripleEquals) {
            _xifexpression = null;
        } else {
            EObject _eContainer_1 = element.eContainer();
            _xifexpression = (NamedElement)_eContainer_1;
        }
        return _xifexpression;
    }

    public static NamedElement getRoot(CommonElement element) {
        NamedElement _xblockexpression = null;
        CommonElement elem = element;
        while (elem != null && XTUMLRTUtil.getOwner(elem) != null) {
            NamedElement _owner = XTUMLRTUtil.getOwner(elem);
            elem = _owner;
        }
        Object _xifexpression = null;
        _xifexpression = elem instanceof Model || elem instanceof Package ? (NamedElement)elem : null;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Iterable<CapsulePart> getPartRedefinitions(Capsule capsule) {
        EList _parts = capsule.getParts();
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return it.getRedefines() != null && it.getRedefines() instanceof CapsulePart;
            }
        };
        return IterableExtensions.filter((Iterable)_parts, (Functions.Function1)_function);
    }

    public static Iterable<Port> getPortRedefinitions(Capsule capsule) {
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Port;
            }
        };
        return IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getSignalRedefinitions(Protocol protocol) {
        Iterable<Signal> _signals = XTUMLRTUtil.getSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return it.getRedefines() != null && it.getRedefines() instanceof Signal;
            }
        };
        return IterableExtensions.filter(_signals, (Functions.Function1)_function);
    }

    public static Iterable<CapsulePart> getRedefinedParts(Capsule capsule) {
        Iterable<CapsulePart> _partRedefinitions = XTUMLRTUtil.getPartRedefinitions(capsule);
        Functions.Function1<CapsulePart, CapsulePart> _function = new Functions.Function1<CapsulePart, CapsulePart>(){

            public CapsulePart apply(CapsulePart it) {
                RedefinableElement _redefines = it.getRedefines();
                return (CapsulePart)_redefines;
            }
        };
        return IterableExtensions.map(_partRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Port> getRedefinedPorts(Capsule capsule) {
        Iterable<Port> _portRedefinitions = XTUMLRTUtil.getPortRedefinitions(capsule);
        Functions.Function1<Port, Port> _function = new Functions.Function1<Port, Port>(){

            public Port apply(Port it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Port)_redefines;
            }
        };
        return IterableExtensions.map(_portRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Signal> getRedefinedSignals(Protocol protocol) {
        Iterable<Signal> _signalRedefinitions = XTUMLRTUtil.getSignalRedefinitions(protocol);
        Functions.Function1<Signal, Signal> _function = new Functions.Function1<Signal, Signal>(){

            public Signal apply(Signal it) {
                RedefinableElement _redefines = it.getRedefines();
                return (Signal)_redefines;
            }
        };
        return IterableExtensions.map(_signalRedefinitions, (Functions.Function1)_function);
    }

    public static Iterable<Port> getRTPorts(Capsule capsule) {
        LinkedHashSet<Port> _xblockexpression = null;
        LinkedHashSet<Port> ports = new LinkedHashSet<Port>();
        EList _ports = capsule.getPorts();
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                Protocol _type = it.getType();
                return _type != null;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_ports, (Functions.Function1)_function);
        Iterables.addAll(ports, (Iterable)_filter);
        _xblockexpression = ports;
        return _xblockexpression;
    }

    public static Iterable<StructuredType> getSupertypes(StructuredType type) {
        EList _generalizations = type.getGeneralizations();
        List _map = null;
        if (_generalizations != null) {
            Functions.Function1<Generalization, StructuredType> _function = new Functions.Function1<Generalization, StructuredType>(){

                public StructuredType apply(Generalization it) {
                    return it.getSuper();
                }
            };
            _map = ListExtensions.map((List)_generalizations, (Functions.Function1)_function);
        }
        return _map;
    }

    public static Iterable<Signal> getSignals(Protocol protocol) {
        EList _protocolBehaviourFeatures = protocol.getProtocolBehaviourFeatures();
        Functions.Function1<ProtocolBehaviourFeature, Boolean> _function = new Functions.Function1<ProtocolBehaviourFeature, Boolean>(){

            public Boolean apply(ProtocolBehaviourFeature it) {
                return it instanceof Signal;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_protocolBehaviourFeatures, (Functions.Function1)_function);
        Functions.Function1<ProtocolBehaviourFeature, Signal> _function_1 = new Functions.Function1<ProtocolBehaviourFeature, Signal>(){

            public Signal apply(ProtocolBehaviourFeature it) {
                return (Signal)it;
            }
        };
        return IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
    }

    public static <T extends MultiplicityElement & NamedElement> int getUpperBound(T element) {
        String boundSpec = element.getUpperBound();
        try {
            int bound = Integer.parseInt(boundSpec);
            if (bound < 0) {
                String _fullName = QualifiedNames.fullName(element);
                String _plus = "Upper bound must be specified for " + _fullName;
                throw new RuntimeException(_plus);
            }
            return bound;
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                NumberFormatException cfr_ignored_0 = (NumberFormatException)_t;
                String _fullName_1 = QualifiedNames.fullName(element);
                String _plus_1 = "Value of upper bound specified for " + _fullName_1;
                String _plus_2 = String.valueOf(_plus_1) + " could not be determined.";
                throw new RuntimeException(_plus_2);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean isExternalPort(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.EXTERNAL);
    }

    public static boolean isInternalPort(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.INTERNAL);
    }

    public static boolean isRelayPort(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.RELAY);
    }

    public static boolean isSAP(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.SAP);
    }

    public static boolean isSPP(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getKind(), (Object)PortKind.SPP);
    }

    public static boolean isWired(Port port) {
        return port instanceof RTPort && ((RTPort)port).isWired();
    }

    public static boolean isAutomatic(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getRegistration(), (Object)PortRegistration.AUTOMATIC);
    }

    public static boolean isAutomaticLocked(Port port) {
        return port instanceof RTPort && Objects.equal((Object)((RTPort)port).getRegistration(), (Object)PortRegistration.AUTOMATICLOCKED);
    }

    public static boolean isNotification(Port port) {
        return port instanceof RTPort && ((RTPort)port).isNotification();
    }

    public static boolean isPublish(Port port) {
        return port instanceof RTPort && ((RTPort)port).isPublish();
    }

    public static String getRegistrationOverride(Port port) {
        String _xifexpression = null;
        _xifexpression = !(port instanceof RTPort) ? null : ((RTPort)port).getRegistrationOverride();
        return _xifexpression;
    }

    public static <T extends MultiplicityElement & NamedElement> boolean isReplicated(T element) {
        return !Objects.equal((Object)element.getLowerBound(), (Object)1) || !Objects.equal((Object)element.getUpperBound(), (Object)1);
    }

    private static boolean _redefines(Capsule capsule, final Port port) {
        Iterable<Port> _redefinedPorts = XTUMLRTUtil.getRedefinedPorts(capsule);
        Functions.Function1<Port, Boolean> _function = new Functions.Function1<Port, Boolean>(){

            public Boolean apply(Port it) {
                return Objects.equal((Object)it, (Object)port);
            }
        };
        return IterableExtensions.exists(_redefinedPorts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Capsule capsule, final CapsulePart part) {
        Iterable<CapsulePart> _redefinedParts = XTUMLRTUtil.getRedefinedParts(capsule);
        Functions.Function1<CapsulePart, Boolean> _function = new Functions.Function1<CapsulePart, Boolean>(){

            public Boolean apply(CapsulePart it) {
                return Objects.equal((Object)it, (Object)part);
            }
        };
        return IterableExtensions.exists(_redefinedParts, (Functions.Function1)_function);
    }

    private static boolean _redefines(Protocol protocol, final Signal signal) {
        Iterable<Signal> _redefinedSignals = XTUMLRTUtil.getRedefinedSignals(protocol);
        Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                return Objects.equal((Object)it, (Object)signal);
            }
        };
        return IterableExtensions.exists(_redefinedSignals, (Functions.Function1)_function);
    }

    public static Iterable<Capsule> getAllCapsules(EObject model) {
        if (model instanceof Model) {
            return XTUMLRTUtil._getAllCapsules((Model)model);
        }
        if (model instanceof Package) {
            return XTUMLRTUtil._getAllCapsules((Package)model);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(model).toString());
    }

    private static boolean redefines(RedefinableElement capsule, RedefinableElement part) {
        if (capsule instanceof Capsule && part instanceof CapsulePart) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (CapsulePart)part);
        }
        if (capsule instanceof Capsule && part instanceof Port) {
            return XTUMLRTUtil._redefines((Capsule)capsule, (Port)part);
        }
        if (capsule instanceof Protocol && part instanceof Signal) {
            return XTUMLRTUtil._redefines((Protocol)capsule, (Signal)part);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(capsule, part).toString());
    }

    public static class NameComparator
    implements Comparator<NamedElement> {
        @Override
        public int compare(NamedElement o1, NamedElement o2) {
            boolean _equals = Objects.equal((Object)o1, null);
            if (_equals) {
                int _xifexpression = 0;
                boolean _equals_1 = Objects.equal((Object)o2, null);
                _xifexpression = _equals_1 ? 0 : -1;
                return _xifexpression;
            }
            boolean _equals_2 = Objects.equal((Object)o2, null);
            if (_equals_2) {
                return 1;
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            boolean _equals_3 = Objects.equal((Object)name1, null);
            if (_equals_3) {
                int _xifexpression_1 = 0;
                boolean _equals_4 = Objects.equal((Object)name2, null);
                _xifexpression_1 = _equals_4 ? 0 : -1;
                return _xifexpression_1;
            }
            boolean _equals_5 = Objects.equal((Object)name2, null);
            if (_equals_5) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    }
}

