/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.codegen.ui.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrusrt.codegen.papyrus.UMLRTGenerator;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.Model;
import org.eclipse.papyrusrt.xtumlrt.trans.preproc.ModelPreprocessor;
import org.eclipse.papyrusrt.xtumlrt.xtext.ui.outline.UmlrtOutlineTreeProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;

public class UmlrtXtextHandler
extends AbstractHandler {
    protected static final ModelPreprocessor MODEL_PREPROCESSOR = new ModelPreprocessor();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object selected;
        EObject eobj;
        IStructuredSelection selection;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && !(selection = (IStructuredSelection)sel).isEmpty() && (eobj = this.getEObject(selected = selection.getFirstElement())) != null) {
            EObject eobjRoot = EcoreUtil.getRootContainer((EObject)eobj);
            final IStatus status = this.generate(eobjRoot);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"UML-RT Code Generator", null, (IStatus)status);
                }
            });
        }
        return null;
    }

    protected IStatus generate(EObject eobjRoot) {
        IStatus status = null;
        CommonElement element = (CommonElement)eobjRoot;
        String topCapsuleName = UmlrtXtextHandler.getTopCapsuleName(element);
        ArrayList<EObject> targets = new ArrayList<EObject>();
        if (eobjRoot instanceof Model) {
            MODEL_PREPROCESSOR.preprocess((Model)eobjRoot);
            targets.add(eobjRoot);
            status = UMLRTGenerator.INSTANCE.generate(targets, topCapsuleName, false);
        }
        return status;
    }

    private EObject getEObject(Object obj) {
        EObject eobj = null;
        if (obj != null && obj instanceof EObjectNode) {
            EObjectNode on = (EObjectNode)obj;
            EObject baseEobj = UmlrtOutlineTreeProvider.getModelElement();
            Resource resource = baseEobj.eResource();
            eobj = on.getEObject(resource);
        }
        return eobj;
    }

    public static String getTopCapsuleName(CommonElement root) {
        String retVal = null;
        return retVal != null ? retVal : "Top";
    }
}

