/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.trans.umlrt;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.internal.context.TypeContext;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateElementUtil
extends ElementEditServiceUtils {
    public static EObject createElement(Object owner, IHintedType type) {
        return CreateElementUtil.createElement(owner, type, null);
    }

    public static EObject createElement(Object owner, IHintedType type, String name) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)owner);
        ICommand cmd = CreateElementUtil.getCreateChildCommandWithContext((EObject)owner, type);
        GMFtoEMFCommandWrapper emfCommand = new GMFtoEMFCommandWrapper(cmd);
        domain.getCommandStack().execute((Command)emfCommand);
        EObject result = (EObject)emfCommand.getResult().iterator().next();
        if (name != null) {
            CreateElementUtil.renameElement(result, name);
        }
        return result;
    }

    public static void renameElement(EObject element, String name) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
        ICommand renameCmd = CreateElementUtil.getSetNameCommandWithContext(domain, element, name);
        GMFtoEMFCommandWrapper emfRenameCommand = new GMFtoEMFCommandWrapper(renameCmd);
        domain.getCommandStack().execute((Command)emfRenameCommand);
    }

    public static ICommand getCreateChildCommandWithContext(TransactionalEditingDomain editingDomain, EObject owner, IHintedType hintedType) {
        CreateElementRequest request;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)owner);
        EObject target = CreateElementUtil.getTargetFromContext(transactionalEditingDomain, owner, (IEditCommandRequest)(request = new CreateElementRequest(transactionalEditingDomain, owner, (IElementType)hintedType)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)target);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        CreateElementRequest targetRequest = new CreateElementRequest(transactionalEditingDomain, target, (IElementType)hintedType);
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)targetRequest);
        return createGMFCommand;
    }

    public static ICommand getSetNameCommandWithContext(TransactionalEditingDomain editingDomain, EObject context, String name) {
        SetRequest request;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)context);
        EObject target = CreateElementUtil.getTargetFromContext(transactionalEditingDomain, context, (IEditCommandRequest)(request = new SetRequest(context, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)name)));
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)target);
        if (provider == null) {
            return UnexecutableCommand.INSTANCE;
        }
        SetRequest targetRequest = new SetRequest(context, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)name);
        ICommand createGMFCommand = provider.getEditCommand((IEditCommandRequest)targetRequest);
        return createGMFCommand;
    }

    public static ICommand getCreateChildCommandWithContext(EObject owner, IHintedType hintedType) {
        return CreateElementUtil.getCreateChildCommandWithContext(TransactionUtil.getEditingDomain((EObject)owner), owner, hintedType);
    }

    public static EObject getTargetFromContext(TransactionalEditingDomain editingDomain, EObject owner, IEditCommandRequest editRequest) {
        GetEditContextRequest editContextRequest = new GetEditContextRequest(editingDomain, editRequest, (Object)owner);
        editContextRequest.setParameter("Cache_Maps", new HashMap());
        editContextRequest.setEditContext((Object)owner);
        try {
            editContextRequest.setClientContext(TypeContext.getContext());
        }
        catch (ServiceException serviceException) {
            return null;
        }
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)owner);
        if (provider == null) {
            return null;
        }
        EObject target = owner;
        Object result = null;
        ICommand getEditContextCommand = provider.getEditCommand((IEditCommandRequest)editContextRequest);
        if (getEditContextCommand != null) {
            IStatus status = null;
            try {
                InternalTransactionalEditingDomain domain = (InternalTransactionalEditingDomain)editingDomain;
                HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                options.put("silent", true);
                options.put("no_validation", true);
                options.put("no_triggers", true);
                InternalTransaction transaction = domain.startTransaction(false, options);
                try {
                    status = getEditContextCommand.execute(null, null);
                }
                finally {
                    transaction.commit();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (RollbackException rollbackException) {}
            if (status != null && status.isOK()) {
                result = getEditContextCommand.getCommandResult().getReturnValue();
            }
            if (result instanceof EObject) {
                target = (EObject)result;
            }
        }
        return target;
    }
}

