/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.xtumlrt.xtext.trans.umlrt;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.resource.ModelMultiException;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.extension.commands.IModelCreationCommand;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryDescriptor;
import org.eclipse.papyrus.uml.diagram.wizards.category.DiagramCategoryRegistry;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.utils.CodeGenUtils;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.osgi.framework.Bundle;

public class TextToUMLRTGeneratorUtils {
    public static final String SM_PROFILE_PATH = "pathmap://UML_RT_PROFILE/UMLRealTimeSM-addendum.profile.uml";
    public static final String CPP_PROFILE_PATH = "pathmap://UMLRT_CPP/RTCppProperties.profile.uml";
    public static final String DIAGRAM_CATEGORY_ID = "UML-RT";
    public static final ResourceSetImpl rset = new ResourceSetImpl();
    public static Resource UMLPrimitiveTypeResource;
    public static Resource AnsiCLibraryResource;
    public static Resource RTSLibraryResource;

    static {
        ResourceSetImpl rset = new ResourceSetImpl();
        UMLPrimitiveTypeResource = rset.getResource(URI.createURI((String)"pathmap://UML_LIBRARIES/UMLPrimitiveTypes.library.uml"), true);
        AnsiCLibraryResource = rset.getResource(URI.createURI((String)"pathmap://PapyrusC_Cpp_LIBRARIES/AnsiCLibrary.uml"), true);
        RTSLibraryResource = rset.getResource(URI.createURI((String)RTSModelLibraryUtils.RTS_MODLIB_PATHMAP), true);
    }

    public static ModelSet createPapyrusModel(ServicesRegistry registry, final URI uri) throws ServiceException, BackboneException, IOException {
        final ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
        TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(domain){

            protected void doExecute() {
                modelSet.createModels(uri);
            }
        };
        domain.getCommandStack().execute((Command)command);
        TextToUMLRTGeneratorUtils.initRegistry(registry);
        TextToUMLRTGeneratorUtils.initDomainModel(modelSet);
        return modelSet;
    }

    public static void initDomainModel(final ModelSet modelSet) throws BackboneException, IOException {
        TransactionalEditingDomain domain = modelSet.getTransactionalEditingDomain();
        IModelCreationCommand creationCommand = ((DiagramCategoryDescriptor)DiagramCategoryRegistry.getInstance().getDiagramCategoryMap().get(DIAGRAM_CATEGORY_ID)).getCommand();
        creationCommand.createModel(modelSet);
        RecordingCommand smcommand = new RecordingCommand(domain){

            protected void doExecute() {
                try {
                    Package model = (Package)((UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")).lookupRoot();
                    Profile smProfile = (Profile)PackageUtil.loadPackage((URI)URI.createURI((String)TextToUMLRTGeneratorUtils.SM_PROFILE_PATH), (ResourceSet)model.eResource().getResourceSet());
                    if (smProfile != null) {
                        PackageUtil.applyProfile((Package)model, (Profile)smProfile, (boolean)true);
                    }
                    Profile cppProfile = (Profile)PackageUtil.loadPackage((URI)URI.createURI((String)TextToUMLRTGeneratorUtils.CPP_PROFILE_PATH), (ResourceSet)model.eResource().getResourceSet());
                    if (smProfile != null) {
                        PackageUtil.applyProfile((Package)model, (Profile)cppProfile, (boolean)true);
                    }
                }
                catch (NotFoundException e) {
                    CodeGenPlugin.error((String)"Failed to initialize domain model", (Throwable)e);
                }
            }
        };
        domain.getCommandStack().execute((Command)smcommand);
        modelSet.save((IProgressMonitor)new NullProgressMonitor());
    }

    public static void initRegistry(ServicesRegistry registry) {
        try {
            registry.startRegistry();
            registry.getService(IPageManager.class);
        }
        catch (ServiceException serviceException) {}
    }

    public static ServicesRegistry createServicesRegistry() {
        ExtensionServicesRegistry registry = null;
        try {
            registry = new ExtensionServicesRegistry("org.eclipse.papyrus.infra.core");
            registry.startServicesByClassKeys(new Class[]{ModelSet.class});
        }
        catch (ServiceException e) {
            CodeGenPlugin.error((String)"Failed to create service registry", (Throwable)e);
        }
        return registry;
    }

    public static EObject applyStereotype(Element element, EClass definition) {
        return TextToUMLRTGeneratorUtils.applyStereotype(element, element, definition);
    }

    public static EObject applyStereotype(Element element, Element context, EClass definition) {
        return UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)context).applyStereotype(element, definition);
    }

    public static ModelSet getModelSetFromTemplate(URI uri) {
        URI templateUri = URI.createFileURI((String)TextToUMLRTGeneratorUtils.getTemplateUri());
        try {
            ServicesRegistry registry = TextToUMLRTGeneratorUtils.createServicesRegistry();
            ModelSet modelSet = (ModelSet)registry.getService(ModelSet.class);
            modelSet.loadModels(templateUri);
            modelSet.saveAs(uri);
            return modelSet;
        }
        catch (IOException | ModelMultiException | ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getTemplateUri() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.papyrusrt.xtumlrt.xtext.trans");
        if (bundle != null) {
            Path path = new Path("template/model.di");
            URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
            try {
                java.net.URI uri = FileLocator.resolve((URL)url).toURI();
                return CodeGenUtils.simplifyPath((String)uri.getRawPath());
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public static EObject getPrimitiveType(String type) {
        Collection results = UMLUtil.findNamedElements((Resource)AnsiCLibraryResource, (String)("AnsiCLibrary::" + type));
        if (!results.isEmpty()) {
            return (EObject)results.iterator().next();
        }
        results = UMLUtil.findNamedElements((Resource)UMLPrimitiveTypeResource, (String)("PrimitiveTypes::" + type));
        if (!results.isEmpty()) {
            return (EObject)results.iterator().next();
        }
        return null;
    }

    public static EObject getRTSProtocol(String name) {
        Collection results = UMLUtil.findNamedElements((Resource)RTSLibraryResource, (String)("UMLRT-RTS::" + name + "::" + name));
        if (!results.isEmpty()) {
            return (EObject)results.iterator().next();
        }
        return null;
    }
}

