/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.profile.RTCppProperties;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttributeKind implements Enumerator
{
    MEMBER(0, "Member", "Member"),
    GLOBAL(1, "Global", "Global"),
    MUTABLE_MEMBER(2, "MutableMember", "MutableMember"),
    DEFINE(3, "Define", "Define");

    public static final int MEMBER_VALUE = 0;
    public static final int GLOBAL_VALUE = 1;
    public static final int MUTABLE_MEMBER_VALUE = 2;
    public static final int DEFINE_VALUE = 3;
    private static final AttributeKind[] VALUES_ARRAY;
    public static final List<AttributeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttributeKind[]{MEMBER, GLOBAL, MUTABLE_MEMBER, DEFINE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttributeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttributeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttributeKind get(int value) {
        switch (value) {
            case 0: {
                return MEMBER;
            }
            case 1: {
                return GLOBAL;
            }
            case 2: {
                return MUTABLE_MEMBER;
            }
            case 3: {
                return DEFINE;
            }
        }
        return null;
    }

    private AttributeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

