/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.structure;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.Controller;
import org.eclipse.papyrusrt.codegen.cpp.structure.model.Deployment;
import org.eclipse.papyrusrt.codegen.lang.cpp.Name;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CppMainGenerator {
    public void generate(String filePath, String topName, Deployment deployment, Variable slotsVariable) {
        try {
            File file = new File(filePath);
            FileWriter _fileWriter = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(_fileWriter);
            CharSequence _doGenerate = this.doGenerate(topName, deployment, slotsVariable);
            String _string = _doGenerate.toString();
            writer.write(_string);
            writer.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private CharSequence doGenerate(String topName, Deployment deployment, Variable slotsVariable) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("#include \"umlrtmain.hh\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append("#include \"umlrtcontroller.hh\"");
        _builder.newLine();
        _builder.append("#include \"");
        _builder.append(topName, "");
        _builder.append("Controllers.hh\"");
        _builder.newLineIfNotEmpty();
        _builder.append("#include \"umlrtcapsuletocontrollermap.hh\"");
        _builder.newLine();
        _builder.append("#include \"umlrtmessagepool.hh\"");
        _builder.newLine();
        _builder.append("#include \"umlrtsignalelementpool.hh\"");
        _builder.newLine();
        _builder.append("#include \"umlrttimerpool.hh\"");
        _builder.newLine();
        _builder.append("#include \"umlrtuserconfig.hh\"");
        _builder.newLine();
        _builder.append("#include <stdio.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static UMLRTSignalElement signalElementBuffer[USER_CONFIG_SIGNAL_ELEMENT_POOL_SIZE];");
        _builder.newLine();
        _builder.append("static UMLRTSignalElementPool signalElementPool( signalElementBuffer, USER_CONFIG_SIGNAL_ELEMENT_POOL_SIZE );");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static UMLRTMessage messageBuffer[USER_CONFIG_MESSAGE_POOL_SIZE];");
        _builder.newLine();
        _builder.append("static UMLRTMessagePool messagePool( messageBuffer, USER_CONFIG_MESSAGE_POOL_SIZE );");
        _builder.newLine();
        _builder.newLine();
        _builder.append("static UMLRTTimer timers[USER_CONFIG_TIMER_POOL_SIZE];");
        _builder.newLine();
        _builder.append("static UMLRTTimerPool timerPool( timers, USER_CONFIG_TIMER_POOL_SIZE );");
        _builder.newLine();
        _builder.newLine();
        _builder.append("int main( int argc, char * argv[] )");
        _builder.newLine();
        _builder.append("{");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("UMLRTController::initializePools( &signalElementPool, &messagePool, &timerPool );");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("UMLRTMain::setArgs( argc, argv );");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("UMLRTCapsuleToControllerMap::setDefaultSlotList( ");
        Name _name = slotsVariable.getName();
        String _identifier = _name.getIdentifier();
        _builder.append(_identifier, "    ");
        _builder.append(", ");
        int _numInitializedInstances = slotsVariable.getNumInitializedInstances();
        _builder.append((Object)_numInitializedInstances, "    ");
        _builder.append(" );");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if( ! UMLRTMain::targetStartup() )");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return EXIT_FAILURE;");
        _builder.newLine();
        _builder.newLine();
        Iterable<Controller> _controllers = deployment.getControllers();
        for (Controller c : _controllers) {
            _builder.append("    ");
            String _name_1 = c.getName();
            _builder.append(_name_1, "    ");
            _builder.append("->spawn();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("if( ! UMLRTMain::mainLoop() )");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return UMLRTMain::targetShutdown( false );");
        _builder.newLine();
        _builder.newLine();
        Iterable<Controller> _controllers_1 = deployment.getControllers();
        List _list = IterableExtensions.toList(_controllers_1);
        List _reverse = ListExtensions.reverse((List)_list);
        for (Controller c_1 : _reverse) {
            _builder.append("    ");
            String _name_2 = c_1.getName();
            _builder.append(_name_2, "    ");
            _builder.append("->join();");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("    ");
        _builder.append("return UMLRTMain::targetShutdown( true );");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }
}

