/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.designer.languages.common.base.codesync.ChangeObject;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.cpp.AbstractElementGenerator;
import org.eclipse.papyrusrt.codegen.cpp.ChangeTracker;
import org.eclipse.papyrusrt.codegen.cpp.CppCodePattern;
import org.eclipse.papyrusrt.codegen.cpp.XTUMLRT2CppCodeGenerator;
import org.eclipse.papyrusrt.codegen.lang.cpp.name.FileName;
import org.eclipse.papyrusrt.xtumlrt.common.CommonElement;
import org.eclipse.papyrusrt.xtumlrt.common.NamedElement;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.RTSModelLibraryUtils;
import org.eclipse.papyrusrt.xtumlrt.external.predefined.UMLRTProfileUtil;
import org.eclipse.papyrusrt.xtumlrt.trans.from.uml.UML2xtumlrtTranslator;
import org.eclipse.papyrusrt.xtumlrt.util.GeneralUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.util.UMLSwitch;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLChangeTracker
implements ChangeTracker {
    private static ChangeTracker ACTIVE_INSTANCE = null;
    private static Map<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>> alreadyGenerated = new HashMap<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>>();
    private static Map<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>> changed = new HashMap<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>>();
    private static Map<Resource, Map<String, Long>> controllerTimestamps = new HashMap<Resource, Map<String, Long>>();
    private static final String CPP_EXTENSION = ".cc";
    private UML2xtumlrtTranslator translator;
    private EObject top;
    private CppCodePattern cpp;

    public UMLChangeTracker(CppCodePattern cpp) {
        this.cpp = cpp;
        this.translator = cpp.getTranslator();
    }

    @Override
    public void setTop(EObject top) {
        this.top = top;
    }

    public static void setActiveInstance(ChangeTracker trackerInstance) {
        ACTIVE_INSTANCE = trackerInstance;
    }

    public static ChangeTracker getActiveInstance() {
        return ACTIVE_INSTANCE;
    }

    @Override
    public void prune(Map<XTUMLRT2CppCodeGenerator.GeneratorKey, AbstractElementGenerator> generators) {
        Iterator<Map.Entry<XTUMLRT2CppCodeGenerator.GeneratorKey, AbstractElementGenerator>> iterator = generators.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<XTUMLRT2CppCodeGenerator.GeneratorKey, AbstractElementGenerator> next = iterator.next();
            XTUMLRT2CppCodeGenerator.GeneratorKey key = next.getKey();
            Element umlElement = this.translator.getSource((CommonElement)((NamedElement)key.object));
            AbstractElementGenerator generator = next.getValue();
            String outputPath = generator.cpp.getOutputFolder().getAbsolutePath();
            boolean shouldRegenerate = false;
            for (FileName f : generator.getGeneratedFilenames()) {
                File output = new File(String.valueOf(outputPath) + File.separator + f.getAbsolutePath() + CPP_EXTENSION);
                if (!output.exists()) {
                    shouldRegenerate = true;
                    break;
                }
                File header = new File(String.valueOf(outputPath) + File.separator + f.getIncludePath());
                if (header.exists()) continue;
                shouldRegenerate = true;
                break;
            }
            if (key.kind == XTUMLRT2CppCodeGenerator.Kind.Structural) {
                File f;
                File output = new File(String.valueOf(outputPath) + File.separator + generator.cpp.getMainName() + CPP_EXTENSION);
                if (!output.exists()) {
                    shouldRegenerate = true;
                }
                if ((f = this.cpp.getControllerAllocations(GeneralUtil.getName((EObject)this.top))) != null) {
                    long lastModified = f.lastModified();
                    Map<String, Long> map = controllerTimestamps.get(this.top.eResource());
                    if (map == null) {
                        map = new HashMap<String, Long>();
                        controllerTimestamps.put(this.top.eResource(), map);
                    } else {
                        Long timeStamp = map.get(GeneralUtil.getName((EObject)this.top));
                        if (timeStamp != null && timeStamp != lastModified) {
                            shouldRegenerate = true;
                        }
                    }
                    map.put(GeneralUtil.getName((EObject)this.top), lastModified);
                }
            }
            if (shouldRegenerate || !this.alreadyGeneratedContains(key.kind, (EObject)umlElement) || this.changedContains(key.kind, (EObject)umlElement)) continue;
            if (key.kind == XTUMLRT2CppCodeGenerator.Kind.Capsule) {
                boolean portWithChangedProtocol = false;
                for (Port umlPort : UMLRTProfileUtil.getAllRTPorts((Class)((Class)umlElement))) {
                    Package protocol = UMLRTProfileUtil.getProtocol((Port)umlPort);
                    if (!this.changedContains(XTUMLRT2CppCodeGenerator.Kind.Protocol, (EObject)protocol)) continue;
                    portWithChangedProtocol = true;
                    break;
                }
                if (portWithChangedProtocol) continue;
                CodeGenPlugin.getLogger().log(Level.INFO, "Pruning " + ((org.eclipse.uml2.uml.NamedElement)umlElement).getQualifiedName() + " from generation.");
                iterator.remove();
                continue;
            }
            CodeGenPlugin.getLogger().log(Level.INFO, "Pruning " + ((org.eclipse.uml2.uml.NamedElement)umlElement).getQualifiedName() + " from generation.");
            iterator.remove();
        }
    }

    @Override
    public void consumeChanges(Map<XTUMLRT2CppCodeGenerator.GeneratorKey, AbstractElementGenerator> generators) {
        for (XTUMLRT2CppCodeGenerator.GeneratorKey gk : generators.keySet()) {
            Element umlElement = this.translator.getSource((CommonElement)((NamedElement)gk.object));
            this.removeChanged(gk.kind, (EObject)umlElement);
        }
    }

    private boolean alreadyGeneratedContains(XTUMLRT2CppCodeGenerator.Kind kind, EObject object) {
        Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject> multimap;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (multimap = alreadyGenerated.get(resource)) != null) {
            return multimap.containsEntry((Object)kind, (Object)object);
        }
        return false;
    }

    @Override
    public void addAlreadyGenerated(XTUMLRT2CppCodeGenerator.Kind kind, NamedElement object) {
        Resource resource;
        Element source = this.translator.getSource((CommonElement)object);
        if (source != null && (resource = source.eResource()) != null) {
            HashMultimap multimap = alreadyGenerated.get(resource);
            if (multimap == null) {
                multimap = HashMultimap.create();
                alreadyGenerated.put(resource, (Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>)multimap);
            }
            multimap.put((Object)kind, (Object)source);
        }
    }

    private boolean changedContains(XTUMLRT2CppCodeGenerator.Kind kind, EObject object) {
        Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject> multimap;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (multimap = changed.get(resource)) != null) {
            return multimap.containsEntry((Object)kind, (Object)object);
        }
        return false;
    }

    @Override
    public Collection<EObject> getAllChanged() {
        Collection<Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>> allMultiMaps;
        ArrayList<EObject> all = new ArrayList<EObject>();
        if (changed != null && (allMultiMaps = changed.values()) != null) {
            for (Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject> map : allMultiMaps) {
                all.addAll(map.values());
            }
        }
        return all;
    }

    private void removeChanged(XTUMLRT2CppCodeGenerator.Kind kind, EObject object) {
        Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject> multimap;
        Resource resource;
        if (object != null && (resource = object.eResource()) != null && (multimap = changed.get(resource)) != null) {
            multimap.remove((Object)kind, (Object)object);
        }
    }

    @Override
    public void addChanges(List<ChangeObject> changeList) {
        if (changeList != null) {
            ChangeCollector changeCollector = new ChangeCollector(changed);
            HashSet<EObject> alreadyAdded = new HashSet<EObject>();
            for (ChangeObject change : changeList) {
                EObject target = change.eObject;
                if (target == null || alreadyAdded.contains(target)) continue;
                alreadyAdded.add(target);
                changeCollector.doSwitch(target);
            }
        }
    }

    @Override
    public void closeResource(Resource resource) {
        if (changed.remove(resource) != null) {
            CodeGenPlugin.getLogger().log(Level.INFO, "Cleaning up changed map for resource: " + resource.getURI().toString());
        }
        if (alreadyGenerated.remove(resource) != null) {
            CodeGenPlugin.getLogger().log(Level.INFO, "Cleaning up already generated map for resource: " + resource.getURI().toString());
        }
    }

    @Override
    public void resetAll() {
        alreadyGenerated = new HashMap<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>>();
        changed = new HashMap<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>>();
    }

    private class ChangeCollector
    extends UMLSwitch<Boolean> {
        final Map<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>> changed;

        public ChangeCollector(Map<Resource, Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>> changed) {
            this.changed = changed;
        }

        public Boolean defaultCase(EObject object) {
            EObject container = object.eContainer();
            if (container != null) {
                this.doSwitch(container);
            }
            return Boolean.TRUE;
        }

        public Boolean casePackage(Package object) {
            CommonElement xtumlrtElement;
            if (UMLRTProfileUtil.isProtocolContainer((Element)object) && (xtumlrtElement = UMLChangeTracker.this.translator.getGenerated((Element)object)) instanceof org.eclipse.uml2.uml.NamedElement && !RTSModelLibraryUtils.isSystemElement((CommonElement)xtumlrtElement)) {
                this.createChange(XTUMLRT2CppCodeGenerator.Kind.Protocol, (EObject)object);
                for (Element element : ((Package)EcoreUtil.getRootContainer((EObject)object)).getOwnedElements()) {
                    if (!UMLRTProfileUtil.isCapsule((Element)element)) continue;
                    for (Port umlPort : UMLRTProfileUtil.getAllRTPorts((Class)((Class)element))) {
                        if (UMLRTProfileUtil.getProtocol((Port)umlPort) != object) continue;
                        this.doSwitch((EObject)element);
                    }
                }
            }
            return Boolean.TRUE;
        }

        public Boolean caseDataType(DataType object) {
            this.createChange(XTUMLRT2CppCodeGenerator.Kind.BasicClass, (EObject)object);
            return Boolean.TRUE;
        }

        public Boolean caseBehavior(Behavior object) {
            EObject container = object.eContainer();
            if (container instanceof Class) {
                this.createClassChange((Class)container);
            }
            return this.defaultCase((EObject)object);
        }

        public Boolean caseClass(Class object) {
            this.createClassChange(object);
            if (UMLRTProfileUtil.isCapsule((Element)object)) {
                this.createChange(XTUMLRT2CppCodeGenerator.Kind.Structural, UMLChangeTracker.this.top);
            }
            return Boolean.TRUE;
        }

        private void createClassChange(Class object) {
            if (!UMLRTProfileUtil.isCapsule((Element)object)) {
                this.createChange(XTUMLRT2CppCodeGenerator.Kind.BasicClass, (EObject)object);
            } else {
                this.createChange(XTUMLRT2CppCodeGenerator.Kind.Capsule, (EObject)object);
                Behavior behaviour = object.getClassifierBehavior();
                if (behaviour == null) {
                    behaviour = object.getOwnedBehavior(null);
                }
                if (behaviour instanceof StateMachine) {
                    this.createChange(XTUMLRT2CppCodeGenerator.Kind.StateMachine, (EObject)behaviour);
                } else {
                    this.createChange(XTUMLRT2CppCodeGenerator.Kind.EmptyStateMachine, (EObject)object);
                }
            }
            for (EStructuralFeature.Setting setting : UMLUtil.getInverseReferences((EObject)object)) {
                Classifier specific;
                EObject eo = setting.getEObject();
                if (!(eo instanceof Generalization) || (specific = ((Generalization)eo).getSpecific()) == object || !(specific instanceof Class)) continue;
                this.createClassChange((Class)specific);
            }
        }

        private void createChange(XTUMLRT2CppCodeGenerator.Kind kind, EObject object) {
            Resource resource;
            if (object != null && (resource = object.eResource()) != null) {
                HashMultimap multimap = this.changed.get(resource);
                if (multimap == null) {
                    multimap = HashMultimap.create();
                    this.changed.put(resource, (Multimap<XTUMLRT2CppCodeGenerator.Kind, EObject>)multimap);
                }
                multimap.put((Object)kind, (Object)object);
            }
        }
    }
}

