/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.cpp.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.codegen.cpp.validation.ValidationException;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class StatusFactory {
    public static Status createErrorStatus(EObject element, String msg) {
        return StatusFactory.createErrorStatus(element, msg, "No detailed description available", false);
    }

    public static Status createErrorStatus(EObject element, String msg, String description) {
        return StatusFactory.createErrorStatus(element, msg, description, false);
    }

    public static Status createErrorStatus(EObject element, String msg, String description, boolean throwExn) {
        return StatusFactory.createStatus(ValidationException.Kind.ERROR, element, msg, description, throwExn);
    }

    public static void addErrorStatus(EObject element, String msg, MultiStatus aggregateStatus) {
        StatusFactory.addStatus(ValidationException.Kind.ERROR, element, msg, "No detailed description available", aggregateStatus);
    }

    public static void addErrorStatus(EObject element, String msg, String description, MultiStatus aggregateStatus) {
        StatusFactory.addStatus(ValidationException.Kind.ERROR, element, msg, description, aggregateStatus);
    }

    public static Status createWarningStatus(EObject element, String msg) {
        return StatusFactory.createWarningStatus(element, msg, "No detailed description available", false);
    }

    public static Status createWarningStatus(EObject element, String msg, String description) {
        return StatusFactory.createWarningStatus(element, msg, description, false);
    }

    public static Status createWarningStatus(EObject element, String msg, String description, boolean throwExn) {
        return StatusFactory.createStatus(ValidationException.Kind.WARNING, element, msg, description, throwExn);
    }

    public static void addWarningStatus(EObject element, String msg, MultiStatus aggregateStatus) {
        StatusFactory.addStatus(ValidationException.Kind.WARNING, element, msg, "No detailed description available", aggregateStatus);
    }

    public static void addWarningStatus(EObject element, String msg, String description, MultiStatus aggregateStatus) {
        StatusFactory.addStatus(ValidationException.Kind.WARNING, element, msg, description, aggregateStatus);
    }

    public static Status createStatus(ValidationException.Kind kind, EObject element, String msg, String description, boolean throwExn) {
        try {
            Status _xblockexpression = null;
            ValidationException exception = new ValidationException(kind, element, msg, description);
            int _iStatusOfKind = StatusFactory.getIStatusOfKind(kind);
            String _string = exception.toString();
            Status status = new Status(_iStatusOfKind, "org.eclipse.papyrusrt.codegen", _string, (Throwable)((Object)exception));
            if (throwExn) {
                throw exception;
            }
            _xblockexpression = status;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static void addStatus(ValidationException.Kind kind, EObject element, String msg, String description, MultiStatus aggregateStatus) {
        Status status = StatusFactory.createStatus(kind, element, msg, description, false);
        aggregateStatus.add((IStatus)status);
    }

    public static int getIStatusOfKind(ValidationException.Kind kind) {
        int _switchResult = 0;
        if (kind != null) {
            switch (kind) {
                case ERROR: {
                    _switchResult = 4;
                    break;
                }
                case WARNING: {
                    _switchResult = 2;
                    break;
                }
                default: {
                    _switchResult = 1;
                    break;
                }
            }
        } else {
            _switchResult = 1;
        }
        return _switchResult;
    }
}

