/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.dep;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.papyrusrt.codegen.lang.cpp.HeaderFile;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.Dependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.IForwardDeclarable;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.TypeDependency;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.ElementList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class DependencyList
implements Iterable<Dependency> {
    private final Set<Dependency> deps = new TreeSet<Dependency>();

    @Override
    public Iterator<Dependency> iterator() {
        return this.deps.iterator();
    }

    public boolean add(Dependency dep) {
        if (dep != null) {
            this.deps.add(dep);
        }
        return true;
    }

    public boolean add(DependencyList depList) {
        for (Dependency dep : depList.deps) {
            if (this.add(dep)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.deps.isEmpty();
    }

    public boolean write(CppFormatter fmt) {
        return this.write(null, fmt);
    }

    public boolean write(ElementList container, CppFormatter fmt) {
        ArrayList<Dependency> writtenDeps = new ArrayList<Dependency>();
        HashSet<String> writtenInclude = new HashSet<String>();
        block0: for (Dependency dep : this.deps) {
            for (Dependency d : writtenDeps) {
                if (dep.isProvidedBy(d)) continue block0;
            }
            HeaderFile header = dep.getHeader();
            if (!(header == null || dep.getKind() == Dependency.Kind.Reference && dep instanceof TypeDependency && dep.getComparisonElement() instanceof IForwardDeclarable)) {
                String include = header.getName().getIncludePath();
                if (writtenInclude.contains(include)) continue;
                if (!(dep instanceof DependencyBlob)) {
                    writtenInclude.add(include);
                }
            }
            if (!(container != null && container.equals(dep.getHeader()) || dep.write(fmt))) {
                return false;
            }
            if (dep instanceof DependencyBlob) continue;
            writtenDeps.add(dep);
        }
        return true;
    }
}

