/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.element;

import org.eclipse.papyrusrt.codegen.lang.cpp.CppWriter;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IUserElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.ElementDependencies;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.LinkageSpec;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.NamedElement;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.BlockInitializer;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ConstructorCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.external.ExternalConstructorCall;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class Variable
extends NamedElement
implements IUserElement {
    private final LinkageSpec linkage;
    private final Type type;
    private Expression initializer;

    public Variable(Type type, String ident) {
        this(type, ident, null);
    }

    public Variable(Type type, String ident, Expression initializer) {
        this(LinkageSpec.UNSPECIFIED, type, ident, initializer);
    }

    public Variable(LinkageSpec linkage, Type type, String ident) {
        this(linkage, type, ident, null);
    }

    public Variable(LinkageSpec linkage, Type type, String ident, Expression initializer) {
        super(ident);
        this.linkage = linkage;
        this.type = type;
        this.initializer = initializer;
    }

    public LinkageSpec getLinkage() {
        return this.linkage;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression expr) {
        this.initializer = expr;
    }

    public int getNumInitializedInstances() {
        if (!this.getType().isArray()) {
            return 1;
        }
        if (this.initializer == null) {
            return 0;
        }
        if (this.initializer instanceof BlockInitializer) {
            return ((BlockInitializer)this.initializer).getNumInitializers();
        }
        return 1;
    }

    public boolean addDependencies(DependencyList deps) {
        return this.type.addDependencies(deps) && (this.initializer == null || this.initializer.addDependencies(deps));
    }

    public boolean write(CppFormatter fmt) {
        return this.linkage.write(fmt) && fmt.space() && this.type.write(fmt, this.getName()) && this.writeInitializer(fmt) && fmt.terminate();
    }

    @Override
    public boolean addDependencies(ElementDependencies deps) {
        if (this.linkage == LinkageSpec.STATIC) {
            return this.type.addDependencies(deps.defn()) && (this.initializer == null || this.initializer.addDependencies(deps.defn()));
        }
        return this.type.addDependencies(deps.decl()) && (this.initializer == null || this.initializer.addDependencies(deps.defn()));
    }

    @Override
    public boolean write(CppWriter out) {
        if (this.linkage == LinkageSpec.STATIC) {
            return this.linkage.write(out.defn()) && out.defn().space() && this.type.write(out.defn(), this.getName()) && this.writeInitializer(out.defn()) && out.defn().terminate();
        }
        return this.linkage.write(out.decl()) && out.decl().space() && this.type.write(out.decl(), this.getName()) && out.decl().terminate() && this.type.write(out.defn(), this.getName()) && this.writeInitializer(out.defn()) && out.defn().terminate();
    }

    private boolean writeInitializer(CppFormatter fmt) {
        if (this.initializer instanceof ConstructorCall) {
            return ((ConstructorCall)this.initializer).writeAsInitializer(fmt);
        }
        if (this.initializer instanceof ExternalConstructorCall) {
            return ((ExternalConstructorCall)this.initializer).writeAsInitializer(fmt);
        }
        if (this.initializer != null) {
            return fmt.space() && fmt.write('=') && fmt.space() && this.initializer.write(fmt);
        }
        return true;
    }
}

