/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class BinaryOperation
extends Expression {
    private final Operator operator;
    private final Expression lhs;
    private final Expression rhs;

    public BinaryOperation(Expression lhs, Operator operator, Expression rhs) {
        this.operator = operator;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public static Expression chain(Operator operator, Expression ... expressions) {
        Expression expr = null;
        if (expressions != null && expressions.length > 1) {
            expr = expressions[0];
            int i = 1;
            while (i < expressions.length) {
                expr = new BinaryOperation(expr, operator, expressions[i]);
                ++i;
            }
        }
        return expr;
    }

    @Override
    protected Type createType() {
        return this.lhs.getType();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return this.operator.precedence;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        return this.lhs.addDependencies(deps) && this.rhs.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        return this.lhs.write(fmt, this) && fmt.space() && this.operator.write(fmt) && fmt.space() && this.rhs.write(fmt, this);
    }

    public static enum Operator {
        ASSIGN("=", Expression.Precedence.Precedence15),
        ADD("+", Expression.Precedence.Precedence06),
        SUBTRACT("-", Expression.Precedence.Precedence06),
        MULTIPLY("*", Expression.Precedence.Precedence05),
        DIVIDE("/", Expression.Precedence.Precedence05),
        BITWISE_OR("|", Expression.Precedence.Precedence12),
        BITWISE_AND("&", Expression.Precedence.Precedence10),
        LEFT_SHIFT("<<", Expression.Precedence.Precedence07),
        RIGHT_SHIFT(">>", Expression.Precedence.Precedence07);

        private final String token;
        public final Expression.Precedence precedence;

        private Operator(String token, Expression.Precedence precedence) {
            this.token = token;
            this.precedence = precedence;
        }

        public boolean write(CppFormatter fmt) {
            return fmt.write(this.token);
        }
    }
}

