/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.expr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.Type;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionBlob;
import org.eclipse.papyrusrt.codegen.lang.cpp.expr.ExpressionList;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;

public class ConditionalDirective
extends Expression {
    private final Directive directive;
    private final List<Branch> branches = new ArrayList<Branch>();
    private Branch defaultBranch = null;

    public ConditionalDirective() {
        this(Directive.IF);
    }

    public ConditionalDirective(Directive directive) {
        this.directive = directive;
    }

    public ConditionalDirective(Directive directive, String condition, Expression ... expressions) {
        this.directive = directive;
        ExpressionList list = this.add(new ExpressionBlob(condition));
        list.addAll(expressions);
    }

    @Override
    protected Type createType() {
        return null;
    }

    @Override
    public Expression.Precedence getPrecedence() {
        return null;
    }

    public ExpressionList add(Expression condition) {
        Branch branch = new Branch(condition);
        this.branches.add(branch);
        return branch;
    }

    public ExpressionList defaultBlock() {
        if (this.defaultBranch == null) {
            this.defaultBranch = new Branch(null);
        }
        return this.defaultBranch;
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Branch branch : this.branches) {
            if (branch.addDependencies(deps)) continue;
            return false;
        }
        return this.defaultBranch == null ? true : this.defaultBranch.addDependencies(deps);
    }

    @Override
    public boolean write(CppFormatter fmt) {
        boolean first = true;
        for (Branch branch : this.branches) {
            if (first) {
                first = false;
                if (!fmt.write(this.directive.toString())) {
                    return false;
                }
            } else if (!fmt.write(BranchDirective.ELIF.toString())) {
                return false;
            }
            if (fmt.space() && branch.condition.write(fmt) && fmt.newline() && branch.write(fmt) && fmt.newline()) continue;
            return false;
        }
        if (!(this.defaultBranch == null || fmt.write(BranchDirective.ELSE.toString()) && fmt.newline() && this.defaultBranch.write(fmt) && fmt.newline())) {
            return false;
        }
        return fmt.write(BranchDirective.ENDIF.toString()) && fmt.newline();
    }

    private static class Branch
    extends ExpressionList {
        public final Expression condition;

        public Branch(Expression condition) {
            super(new Expression[0]);
            this.condition = condition;
        }

        @Override
        public boolean addDependencies(DependencyList deps) {
            return (this.condition == null || this.condition.addDependencies(deps)) && super.addDependencies(deps);
        }
    }

    private static enum BranchDirective {
        ELIF,
        ELSE,
        ENDIF;


        public final String toString() {
            return "#" + this.name().toLowerCase();
        }
    }

    public static enum Directive {
        IFDEF,
        IFNDEF,
        IF;


        public final String toString() {
            return "#" + this.name().toLowerCase();
        }
    }
}

