/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.lang.cpp.stmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrusrt.codegen.lang.cpp.Expression;
import org.eclipse.papyrusrt.codegen.lang.cpp.IGeneratable;
import org.eclipse.papyrusrt.codegen.lang.cpp.Statement;
import org.eclipse.papyrusrt.codegen.lang.cpp.dep.DependencyList;
import org.eclipse.papyrusrt.codegen.lang.cpp.element.Variable;
import org.eclipse.papyrusrt.codegen.lang.cpp.internal.CppFormatter;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.BreakStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.CodeBlock;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ExpressionStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.ReturnStatement;
import org.eclipse.papyrusrt.codegen.lang.cpp.stmt.VariableDeclarationStatement;

public class SwitchClause
implements IGeneratable {
    private final List<Expression> labels = new ArrayList<Expression>();
    private final List<Statement> body = new ArrayList<Statement>();
    private boolean isFallthrough = false;

    public SwitchClause() {
        this.labels.add(null);
    }

    public SwitchClause(Expression ... labels) {
        this.labels.addAll(Arrays.asList(labels));
    }

    public void addLabel(Expression label) {
        this.labels.add(label);
    }

    public void addDefault() {
        this.labels.add(null);
    }

    public boolean isFallthrough() {
        return this.isFallthrough;
    }

    public void setFallthrough(boolean b) {
        this.isFallthrough = b;
    }

    public void add(Statement stmt) {
        this.body.add(stmt);
    }

    public void add(Expression expr) {
        this.add(new ExpressionStatement(expr));
    }

    public void add(Variable var) {
        this.add(new VariableDeclarationStatement(var));
    }

    private static boolean needsBraces(Iterable<Statement> stmts) {
        for (Statement stmt : stmts) {
            if (stmt instanceof VariableDeclarationStatement) {
                return true;
            }
            if (!(stmt instanceof CodeBlock)) continue;
            return SwitchClause.needsBraces(((CodeBlock)stmt).getStatements());
        }
        return false;
    }

    public boolean clauseFallsthrough() {
        if (this.body.size() <= 0) {
            return true;
        }
        Statement last = this.body.get(this.body.size() - 1);
        return !(last instanceof ReturnStatement) && !(last instanceof BreakStatement);
    }

    @Override
    public boolean addDependencies(DependencyList deps) {
        for (Expression expr : this.labels) {
            if (expr == null || expr.addDependencies(deps)) continue;
            return false;
        }
        for (Statement stmt : this.body) {
            if (stmt.addDependencies(deps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(CppFormatter fmt) {
        for (Expression label : this.labels) {
            if ((label == null ? fmt.write("default") : fmt.write("case ") && label.write(fmt)) && fmt.writeLn(':')) continue;
            return false;
        }
        boolean needsBraces = SwitchClause.needsBraces(this.body);
        if (needsBraces ? !fmt.openBrace() : !fmt.incIndent()) {
            return false;
        }
        for (Statement stmt : this.body) {
            if (stmt.write(fmt)) continue;
            return false;
        }
        if (needsBraces ? !fmt.closeBrace() : !fmt.decIndent()) {
            return false;
        }
        if (!this.clauseFallsthrough()) {
            return true;
        }
        return fmt.incIndent() && fmt.writeLn("// break intentionally omitted") && fmt.decIndent();
    }
}

