/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.codegen.build;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrusrt.codegen.CodeGenPlugin;
import org.eclipse.papyrusrt.codegen.EObjectLocator;
import org.eclipse.papyrusrt.codegen.UserEditableRegion;
import org.eclipse.papyrusrt.codegen.build.BuildNotifier;
import org.eclipse.uml2.common.util.UML2Util;

public class GeneratedSrcBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.papyrusrt.codegen.umlrtgensrcbuilder";
    private static final Pattern BEGIN_TAG_PATTERN = Pattern.compile("/\\* UMLRTGEN-USERREGION-BEGIN .*\\*/");
    private static final Pattern END_TAG_PATTERN = Pattern.compile("/\\* UMLRTGEN-USERREGION-END \\*/");
    private static final String EMPTY = "";
    private static final String CR = "\n";
    private IProject currentProject;
    private BuildNotifier notifier;
    private List<String> reservedNames;
    private List<String> fileExtensions;
    private int lineNum = 1;
    private UserEditableRegion activeRegion;
    private final Map<String, UserEditableRegion> regions = new LinkedHashMap<String, UserEditableRegion>();
    private String tag = "";
    private String extra = "";

    public GeneratedSrcBuilder() {
        this.reservedNames = new ArrayList<String>();
        Collections.addAll(this.reservedNames, ".cproject", ".project");
        this.fileExtensions = new ArrayList<String>();
        Collections.addAll(this.fileExtensions, "cc");
    }

    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.currentProject = this.getProject();
        if (this.currentProject == null || !this.currentProject.isAccessible()) {
            return new IProject[0];
        }
        this.notifier = new BuildNotifier(monitor, this.currentProject);
        this.notifier.begin();
        try {
            this.notifier.checkCancel();
            this.lineNum = 1;
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.currentProject);
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        finally {
            this.notifier.done();
            this.cleanup();
        }
        return null;
    }

    private void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) {
        this.notifier.checkCancel();
        this.notifier.subTask(NLS.bind((String)"Preparing incremental build for project ", (Object)this.currentProject.getName()));
        try {
            EObjectLocator.getInstance().initLocators();
            delta.accept((IResourceDeltaVisitor)new GenSrcBuildDeltaVisitor());
            EObjectLocator.getInstance().cleanUpLocators();
        }
        catch (CoreException e) {
            CodeGenPlugin.error(NLS.bind((String)"Error during incremental build for project ", (Object)this.currentProject.getName()), e);
        }
    }

    private void fullBuild(IProgressMonitor monitor) {
        this.notifier.checkCancel();
        this.notifier.subTask(NLS.bind((String)"Preparing full build for project ", (Object)this.currentProject.getName()));
        try {
            EObjectLocator.getInstance().initLocators();
            this.currentProject.accept((IResourceVisitor)new GenSrcBuildVisitor());
            EObjectLocator.getInstance().cleanUpLocators();
        }
        catch (CoreException e) {
            CodeGenPlugin.error(NLS.bind((String)"Error during full build for project ", (Object)this.currentProject.getName()), e);
        }
    }

    private void cleanup() {
        this.notifier = null;
        this.regions.clear();
        this.activeRegion = null;
    }

    private boolean isProjectFile(IResource resource) {
        return this.reservedNames.contains(resource.getName());
    }

    private boolean isGeneratedResource(IResource resource) {
        return this.fileExtensions.contains(resource.getFileExtension());
    }

    private boolean isBeginUserTag(String line) {
        boolean result = false;
        this.tag = EMPTY;
        this.extra = EMPTY;
        Matcher matcher = BEGIN_TAG_PATTERN.matcher(line);
        if (matcher.find()) {
            this.tag = line.substring(matcher.start(), matcher.end());
            if (matcher.end() + 1 < line.length()) {
                this.extra = line.substring(matcher.end() + 1, line.length());
            }
            result = true;
        }
        return result;
    }

    private boolean isEndUserTag(String line) {
        boolean result = false;
        this.extra = EMPTY;
        Matcher matcher = END_TAG_PATTERN.matcher(line.trim());
        if (matcher.find()) {
            if (matcher.start() > 0) {
                this.extra = line.substring(0, matcher.start());
            }
            result = true;
        }
        return result;
    }

    private void error(IResource resource, String message) {
        try {
            IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
            marker.setAttribute("severity", 2);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("lineNumber", this.lineNum);
            marker.setAttribute("charStart", -1);
            marker.setAttribute("charEnd", -1);
        }
        catch (CoreException e) {
            CodeGenPlugin.error("Error while generating problem marker", e);
        }
    }

    private void enterActiveRegion(IResource resource, String label) {
        UserEditableRegion region;
        if (this.activeRegion != null) {
            this.error(resource, "Overlapping editable regions: Check for a valid preceding end tag");
            this.regions.remove(this.activeRegion.getUserRegionTag());
            this.activeRegion = null;
        }
        if ((region = this.regions.get(label)) != null) {
            this.error(resource, NLS.bind((String)"Duplicate editable region: Region with same label declared on line ", (Object)region.getLine()));
            return;
        }
        this.activeRegion = new UserEditableRegion(label, this.lineNum);
        this.regions.put(label, this.activeRegion);
    }

    private void exitActiveRegion(IResource resource) {
        if (this.activeRegion != null) {
            this.activeRegion = null;
        } else {
            this.error(resource, "Unexpected region ending: Check for missing region begin tag");
        }
    }

    private void updateModelUserRegions(IResource resource) {
        Reader reader = null;
        try {
            try {
                reader = new InputStreamReader(((IFile)resource).getContents());
                BufferedReader br = new BufferedReader(reader);
                String currentLine = br.readLine();
                while (currentLine != null) {
                    if (this.isBeginUserTag(currentLine)) {
                        this.enterActiveRegion(resource, this.getLabel(this.tag));
                        if (!this.extra.isEmpty() && this.activeRegion != null) {
                            this.activeRegion.getUserText().append(String.valueOf(this.extra) + CR);
                        }
                    } else if (this.isEndUserTag(currentLine)) {
                        if (!this.extra.isEmpty() && this.activeRegion != null) {
                            this.activeRegion.getUserText().append(String.valueOf(this.extra) + CR);
                        }
                        this.exitActiveRegion(resource);
                    } else if (currentLine != null && this.activeRegion != null) {
                        this.activeRegion.getUserText().append(String.valueOf(currentLine) + CR);
                    }
                    currentLine = br.readLine();
                    ++this.lineNum;
                }
                this.commit(resource);
            }
            catch (CoreException e) {
                CodeGenPlugin.error(NLS.bind((String)"Error getting file contents for ", (Object)resource.getName()), e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e2) {
                    CodeGenPlugin.error(NLS.bind((String)"Error closing reader for ", (Object)resource.getName()), e2);
                }
            }
            catch (IOException e) {
                CodeGenPlugin.error(NLS.bind((String)"Error reading line for ", (Object)resource.getName()), e);
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e3) {
                    CodeGenPlugin.error(NLS.bind((String)"Error closing reader for ", (Object)resource.getName()), e3);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                CodeGenPlugin.error(NLS.bind((String)"Error closing reader for ", (Object)resource.getName()), e);
            }
        }
    }

    private String getLabel(String beginTag) {
        int start = "/* UMLRTGEN-USERREGION-BEGIN ".length();
        return beginTag.substring(start, beginTag.length());
    }

    private void commit(IResource resource) {
        HashSet<Resource> resourcesToSave = new HashSet<Resource>();
        HashSet<String> errorResource = new HashSet<String>();
        for (UserEditableRegion region : this.regions.values()) {
            UserEditableRegion.CommitResult result = region.commit();
            if (result != null && result.getTarget() != null && result.shouldSave()) {
                resourcesToSave.add(result.getTarget().eResource());
            }
            if (result.getTarget() != null || UML2Util.isEmpty((String)result.getUri())) continue;
            errorResource.add(result.getUri());
        }
        EObjectLocator.getInstance().flushChanges();
        if (!errorResource.isEmpty()) {
            StringBuilder builder = new StringBuilder("Target elements not found. Re-generate code and/or delete obsolete source files for following resources:");
            for (String uri : errorResource) {
                builder.append(String.valueOf(System.lineSeparator()) + uri);
            }
            CodeGenPlugin.warning(builder.toString());
        }
        for (Resource r : resourcesToSave) {
            try {
                ResourceSet rset = r.getResourceSet();
                if (rset instanceof ModelSet) {
                    r.save(Collections.EMPTY_MAP);
                    continue;
                }
                r.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                CodeGenPlugin.error(e);
            }
        }
    }

    private class GenSrcBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        GenSrcBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && !GeneratedSrcBuilder.this.isProjectFile(resource) && GeneratedSrcBuilder.this.isGeneratedResource(resource)) {
                switch (delta.getKind()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 4: {
                        GeneratedSrcBuilder.this.updateModelUserRegions(resource);
                    }
                }
            }
            return true;
        }
    }

    private class GenSrcBuildVisitor
    implements IResourceVisitor {
        GenSrcBuildVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 1 && !GeneratedSrcBuilder.this.isProjectFile(resource) && GeneratedSrcBuilder.this.isGeneratedResource(resource)) {
                GeneratedSrcBuilder.this.updateModelUserRegions(resource);
            }
            return true;
        }
    }
}

