/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.EditHelperContext;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeRequest;
import org.eclipse.papyrusrt.umlrt.core.commands.IExcludeElementRequest;
import org.eclipse.uml2.uml.Element;

public final class ExcludeDependentsRequest
extends AbstractEditCommandRequest
implements IExcludeElementRequest {
    private final Set<Element> dependentElementsToExclude = new LinkedHashSet<Element>();
    private final Set<Element> immutableViewOfDependents = Collections.unmodifiableSet(this.dependentElementsToExclude);
    private ExcludeRequest initialExcludeRequest;
    private Element elementToExclude;

    public ExcludeDependentsRequest(ExcludeRequest excludeRequest) {
        super(Objects.requireNonNull(excludeRequest, "excludeRequest").getEditingDomain());
        this.initialExcludeRequest = excludeRequest;
        this.setElementToExclude(excludeRequest.getElementToExclude());
    }

    @Override
    public final Element getElementToExclude() {
        return this.elementToExclude;
    }

    @Override
    public final void setElementToExclude(Element element) {
        this.elementToExclude = Objects.requireNonNull(element, "element");
        this.dependentElementsToExclude.add(element);
    }

    @Override
    public boolean isExclude() {
        return this.initialExcludeRequest.isExclude();
    }

    public List getElementsToEdit() {
        return Collections.singletonList(this.getElementToExclude());
    }

    public IClientContext getClientContext() {
        IClientContext result = super.getClientContext();
        if (result == null) {
            result = this.initialExcludeRequest.getClientContext();
        }
        return result;
    }

    public Object getEditHelperContext() {
        IClientContext context = this.getClientContext();
        Element excludee = this.getElementToExclude();
        Object result = context == null ? excludee : new EditHelperContext((EObject)excludee, context);
        return result;
    }

    public final Set<Element> getDependentElementsToDestroy() {
        return this.immutableViewOfDependents;
    }

    public ICommand getExcludeDependentCommand(Element dependent) {
        ICommand result = null;
        if (this.addDependentElementToExclude(dependent)) {
            Element elementBeingExcluded = this.getElementToExclude();
            try {
                ExcludeRequest exclude = new ExcludeRequest(this.getEditingDomain(), dependent, this.isExclude());
                exclude.setClientContext(this.getClientContext());
                exclude.addParameters(this.getParameters());
                exclude.setParameter("ExcludeRequest.excludeDependentsRequest", this);
                this.setElementToExclude(dependent);
                Object eHelperContext = exclude.getEditHelperContext();
                IElementType context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
                if (context != null) {
                    result = context.getEditCommand((IEditCommandRequest)exclude);
                }
            }
            finally {
                this.setElementToExclude(elementBeingExcluded);
            }
        }
        return result;
    }

    public ICommand getExcludeDependentsCommand(Collection<? extends Element> dependents) {
        return dependents.stream().map(this::getExcludeDependentCommand).filter(Objects::nonNull).reduce(CompositeCommand::compose).orElse(null);
    }

    protected boolean addDependentElementToExclude(Element dependent) {
        if (Objects.requireNonNull(dependent, "dependent") == this.getElementToExclude()) {
            throw new IllegalArgumentException("dependent is the element being excluded");
        }
        return !this.isElementToBeExcluded(dependent) && this.dependentElementsToExclude.add(dependent);
    }

    protected boolean isElementToBeExcluded(Element element) {
        boolean result = false;
        Element excludee = this.getElementToExclude();
        Element toCheck = element;
        while (!result && toCheck != null) {
            result = toCheck == excludee || this.dependentElementsToExclude.contains(toCheck);
            toCheck = toCheck.eContainer();
        }
        return result;
    }
}

