/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.commands;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.context.TypeContext;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeRequest;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTFactory;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTInheritanceKind;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class ExclusionCommand
extends AbstractTransactionalCommand {
    private List<Element> elements;
    private boolean exclude;

    public ExclusionCommand(Element element, boolean exclude) {
        this(TransactionUtil.getEditingDomain((EObject)element), element, exclude);
    }

    public ExclusionCommand(TransactionalEditingDomain domain, Element element, boolean exclude) {
        this(domain, Collections.singletonList(element), exclude);
    }

    public ExclusionCommand(TransactionalEditingDomain domain, Collection<? extends Element> elements, boolean exclude) {
        this(domain, (List<Element>)ImmutableList.copyOf(elements), exclude);
    }

    private ExclusionCommand(TransactionalEditingDomain domain, List<Element> elements, boolean exclude) {
        super(domain, exclude ? "Exclude Element" : "Re-inherit Element", ExclusionCommand.getWorkspaceFiles(elements));
        if (elements.isEmpty()) {
            throw new IllegalArgumentException("no elements");
        }
        this.elements = elements;
        this.exclude = exclude;
    }

    public List<? extends Element> getElements() {
        return this.elements;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public boolean canExecute() {
        return super.canExecute() && this.elements.stream().allMatch(this::isInherited);
    }

    protected UMLRTNamedElement getUMLRTNamedElement(Element element) {
        return element instanceof NamedElement ? UMLRTFactory.create((NamedElement)((NamedElement)element)) : null;
    }

    protected boolean isInherited(Element element) {
        return UMLRTInheritanceKind.of((Element)element) != UMLRTInheritanceKind.NONE;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Not executable");
        }
        Predicate<UMLRTNamedElement> action = this.exclude ? UMLRTNamedElement::exclude : UMLRTNamedElement::reinherit;
        CommandResult result = CommandResult.newOKCommandResult(this.getElements().stream().map(this::getUMLRTNamedElement).filter(Objects::nonNull).filter(action).map(UMLRTNamedElement::toUML).collect(Collectors.toList()));
        return result;
    }

    public static ICommand getExclusionCommand(TransactionalEditingDomain domain, Collection<? extends Element> elements, boolean exclude) {
        return elements.stream().map(ExcludeRequest.serialRequest(domain, exclude)).map(ExclusionCommand::getExclusionCommand).filter(Objects::nonNull).reduce(ICommand::compose).orElse((ICommand)UnexecutableCommand.INSTANCE);
    }

    public static ICommand getExclusionCommand(TransactionalEditingDomain domain, Element element, boolean exclude) {
        return ExclusionCommand.getExclusionCommand(new ExcludeRequest(domain, element, exclude));
    }

    private static ICommand getExclusionCommand(ExcludeRequest request) {
        IElementType typeToEdit;
        ICommand result = null;
        if (request.getClientContext() == null) {
            try {
                request.setClientContext(TypeContext.getContext((EObject)request.getElementToExclude()));
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        if ((typeToEdit = ElementTypeRegistry.getInstance().getElementType(request.getEditHelperContext())) != null) {
            result = typeToEdit.getEditCommand((IEditCommandRequest)request);
        }
        return result;
    }

    public static ICommand getExclusionCommand(Collection<? extends Element> elements, boolean exclude) {
        return elements.stream().map(ExcludeRequest.serialRequest(exclude)).map(ExclusionCommand::getExclusionCommand).filter(Objects::nonNull).reduce(ICommand::compose).orElse(null);
    }

    public static ICommand getExclusionCommand(Element element, boolean exclude) {
        return ExclusionCommand.getExclusionCommand(new ExcludeRequest(element, exclude));
    }
}

