/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.internal.types.advice;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class AppliedStereotypesMoveAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterMoveCommand(MoveRequest request) {
        AbstractTransactionalCommand result = null;
        EObject destination = request.getTargetContainer();
        if (destination instanceof Element && UMLRTProfileUtils.isUMLRTProfileApplied((Element)destination)) {
            Resource destinationResource = destination.eResource();
            Set elementsToMove = request.getElementsToMove().keySet();
            List<Element> crossResourceMoves = elementsToMove.stream().filter(e -> ((InternalEObject)e).eDirectResource() == null && e.eResource() != destinationResource).filter(Element.class::isInstance).map(Element.class::cast).filter(UMLRTProfileUtils::isUMLRTProfileApplied).collect(Collectors.toList());
            if (!crossResourceMoves.isEmpty()) {
                ArrayListMultimap stereotypeApplications = ArrayListMultimap.create();
                crossResourceMoves.forEach(arg_0 -> this.lambda$1((Multimap)stereotypeApplications, arg_0));
                if (!stereotypeApplications.isEmpty()) {
                    result = new AbstractTransactionalCommand(request.getEditingDomain(), "Move Stereotype Applications", null, (Multimap)stereotypeApplications){
                        private final /* synthetic */ Multimap val$stereotypeApplications;
                        {
                            this.val$stereotypeApplications = multimap;
                            super($anonymous0, $anonymous1, $anonymous2);
                        }

                        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                            for (Element next : this.val$stereotypeApplications.keySet()) {
                                UMLUtil.StereotypeApplicationHelper helper = UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)next);
                                this.val$stereotypeApplications.get((Object)next).stream().forEach(a -> {
                                    boolean bl = helper.addToContainmentList(next, a);
                                });
                            }
                            return CommandResult.newOKCommandResult();
                        }
                    };
                }
            }
        }
        return result;
    }

    private void collectStereotypeApplications(Element movedElement, Multimap<Element, EObject> result) {
        TreeIterator iter = EcoreUtil.getAllProperContents(Collections.singleton(movedElement), (boolean)false);
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (!(next instanceof Element)) continue;
            Element element = (Element)next;
            Resource resource = element.eResource();
            element.getStereotypeApplications().stream().filter(a -> a.eResource() == resource).forEach(a -> {
                boolean bl = result.put((Object)element, a);
            });
        }
    }

    private /* synthetic */ void lambda$1(Multimap multimap, Element moved) {
        this.collectStereotypeApplications(moved, (Multimap<Element, EObject>)multimap);
    }
}

