/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnector;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTPort;
import org.eclipse.uml2.uml.Port;

public abstract class AbstractPortEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        UMLRTPort port;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (request.isExclude() && request.getElementToExclude() instanceof Port && (port = UMLRTPort.getInstance((Port)((Port)request.getElementToExclude()))) != null) {
            ICommand excludeConnectors;
            Predicate<UMLRTNamedElement> alreadyExcluded = UMLRTNamedElement::isExcluded;
            List connectorsToExclude = Stream.concat(port.getInsideConnectors().stream(), port.getOutsideConnectors().stream()).filter(alreadyExcluded.negate()).map(UMLRTConnector::toUML).collect(Collectors.toList());
            if (!connectorsToExclude.isEmpty() && (excludeConnectors = request.getExcludeDependentsCommand(connectorsToExclude)) != null) {
                result = CompositeCommand.compose((ICommand)result, (ICommand)excludeConnectors);
            }
        }
        return result;
    }
}

