/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.types.advice;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrusrt.umlrt.core.commands.ExcludeDependentsRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.types.advice.IInheritanceEditHelperAdvice;
import org.eclipse.papyrusrt.umlrt.core.utils.RegionUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.StateMachineUtils;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTCommandUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTConnectionPoint;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTNamedElement;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTState;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTVertex;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.UMLPackage;

public class RTStateEditHelperAdvice
extends AbstractEditHelperAdvice
implements IInheritanceEditHelperAdvice {
    public boolean approveRequest(IEditCommandRequest request) {
        Boolean result = null;
        if (request instanceof CreateElementRequest) {
            result = this.approveCreateElementRequest((CreateElementRequest)request);
        } else if (request instanceof MoveRequest) {
            result = this.approveMoveRequest((MoveRequest)request);
        } else if (request instanceof SetRequest) {
            result = this.approveSetRequest((SetRequest)request);
        }
        if (result == null) {
            result = super.approveRequest(request);
        }
        return result;
    }

    protected boolean approveSetRequest(SetRequest request) {
        EStructuralFeature feature = request.getFeature();
        for (Object o : request.getElementsToEdit()) {
            if (!(o instanceof State) || !UMLPackage.Literals.STATE__CONNECTION_POINT.equals(feature)) continue;
            return false;
        }
        return super.approveRequest((IEditCommandRequest)request);
    }

    protected boolean approveMoveRequest(MoveRequest request) {
        if (!(request.getTargetContainer() instanceof Region)) {
            Set moved = request.getElementsToMove().keySet();
            Predicate<Object> isConnectionPoint = StateMachineUtils::isConnectionPoint;
            Predicate<Object> isPastedConnectionPoint = isConnectionPoint.and(o -> ((EObject)o).eResource() == null);
            return request.getTargetContainer() instanceof State && moved.stream().allMatch(isPastedConnectionPoint);
        }
        return RegionUtils.shouldApproveMoveRequest(request);
    }

    private Boolean approveCreateElementRequest(CreateElementRequest request) {
        Boolean result = null;
        IElementType typeToCreate = request.getElementType();
        if (ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLElementTypes.REGION)) {
            if (request.getContainer() instanceof State) {
                State stateToEdit = (State)request.getContainer();
                result = !stateToEdit.isComposite();
            }
        } else if (ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)UMLElementTypes.PSEUDOSTATE)) {
            result = UMLRTElementTypesEnumerator.getAllRTTypes().stream().anyMatch(rtType -> ElementTypeUtils.isTypeCompatible(typeToCreate, (IElementType)rtType));
        }
        return result;
    }

    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        ICommand result = this.getInheritanceEditCommand(request);
        if (result == null) {
            result = super.getBeforeEditCommand(request);
        }
        return result;
    }

    @Override
    public ICommand getExcludeDependentsCommand(ExcludeDependentsRequest request) {
        ICommand refactorTransitions;
        ICommand result = IInheritanceEditHelperAdvice.super.getExcludeDependentsCommand(request);
        if (request.isExclude() && request.getElementToExclude() instanceof State) {
            UMLRTState state = UMLRTState.getInstance((State)((State)request.getElementToExclude()));
            if (state != null) {
                ICommand excludeTransitions;
                Predicate<UMLRTNamedElement> alreadyExcluded = UMLRTNamedElement::isExcluded;
                List transitionsToExclude = Stream.concat(state.getIncomings().stream(), state.getOutgoings().stream()).distinct().filter(alreadyExcluded.negate()).map(UMLRTTransition::toUML).collect(Collectors.toList());
                List connectionPointTransitions = Stream.concat(state.getEntryPoints().stream().flatMap(cp -> cp.getIncomings().stream()), state.getExitPoints().stream().flatMap(cp -> cp.getOutgoings().stream())).distinct().filter(alreadyExcluded.negate()).map(UMLRTTransition::toUML).collect(Collectors.toList());
                if (!connectionPointTransitions.isEmpty()) {
                    if (transitionsToExclude.isEmpty()) {
                        transitionsToExclude = connectionPointTransitions;
                    } else {
                        transitionsToExclude.addAll(connectionPointTransitions);
                    }
                }
                if (!transitionsToExclude.isEmpty() && (excludeTransitions = request.getExcludeDependentsCommand(transitionsToExclude)) != null) {
                    result = CompositeCommand.compose((ICommand)result, (ICommand)excludeTransitions);
                }
            }
        } else if (!request.isExclude() && request.getElementToExclude() instanceof State && (refactorTransitions = this.getTransitionRefactoring(request)) != null) {
            result = UMLRTCommandUtils.flatCompose(refactorTransitions, result);
        }
        return result;
    }

    public void configureRequest(IEditCommandRequest request) {
        if (request instanceof MoveRequest) {
            StateMachineUtils.retargetToRegion((MoveRequest)request);
        }
    }

    protected ICommand getTransitionRefactoring(ExcludeDependentsRequest reinherit) {
        ICommand result = null;
        UMLRTState state = UMLRTState.getInstance((State)((State)reinherit.getElementToExclude()));
        if (state != null && state.isInherited()) {
            Predicate<UMLRTNamedElement> isinherited = UMLRTNamedElement::isInherited;
            Predicate<UMLRTNamedElement> isLocal = isinherited.negate();
            result = state.getEntryPoints().stream().filter(isLocal).map(UMLRTVertex::getIncomings).flatMap(Collection::stream).map(t -> this.getRefactoring(reinherit, (UMLRTTransition)t, state)).reduce(result, UMLRTCommandUtils::flatCompose);
            result = state.getExitPoints().stream().filter(isLocal).map(UMLRTVertex::getOutgoings).flatMap(Collection::stream).map(t -> this.getRefactoring(reinherit, (UMLRTTransition)t, state)).reduce(result, UMLRTCommandUtils::flatCompose);
        }
        return result;
    }

    protected ICommand getRefactoring(ExcludeDependentsRequest reinherit, UMLRTTransition transition, UMLRTState reinherited) {
        ICommand result = null;
        UMLRTTransition parent = transition.getRedefinedTransition();
        HashSet<EReference> unsetFeatures = new HashSet<EReference>();
        boolean willBeComposite = reinherited.getRedefinedState().isComposite();
        if (transition.getTarget() instanceof UMLRTConnectionPoint) {
            if (!(parent != null && reinherited.redefines((UMLRTNamedElement)parent.getTarget()) || willBeComposite)) {
                UMLRTConnectionPoint target = (UMLRTConnectionPoint)transition.getTarget();
                if (target.getState() == reinherited) {
                    result = UMLRTCommandUtils.flatCompose(result, this.setTarget(reinherit, transition, (UMLRTVertex)reinherited));
                }
            } else if (parent == null) {
                result = UMLRTCommandUtils.flatCompose(result, this.delete(reinherit, transition));
            } else {
                result = UMLRTCommandUtils.flatCompose(result, this.unsetTarget(reinherit, transition));
                unsetFeatures.add(UMLPackage.Literals.TRANSITION__TARGET);
            }
        }
        if (transition.getSource() instanceof UMLRTConnectionPoint) {
            if (!(parent != null && reinherited.redefines((UMLRTNamedElement)parent.getSource()) || willBeComposite)) {
                UMLRTConnectionPoint source = (UMLRTConnectionPoint)transition.getSource();
                if (source.getState() == reinherited) {
                    result = UMLRTCommandUtils.flatCompose(result, this.setSource(reinherit, transition, (UMLRTVertex)reinherited));
                }
            } else if (parent == null) {
                result = UMLRTCommandUtils.flatCompose(result, this.delete(reinherit, transition));
            } else {
                result = UMLRTCommandUtils.flatCompose(result, this.unsetSource(reinherit, transition));
                unsetFeatures.add(UMLPackage.Literals.TRANSITION__SOURCE);
            }
        }
        if (transition.isInherited() && !unsetFeatures.isEmpty()) {
            boolean canReinherit = true;
            Transition uml = transition.toUML();
            for (EStructuralFeature next : uml.eClass().getEAllStructuralFeatures()) {
                if (!next.isChangeable() || next.isDerived() || next instanceof EReference && ((EReference)next).isContainer() || next == UMLPackage.Literals.TRANSITION__REDEFINED_TRANSITION || !uml.eIsSet(next) || unsetFeatures.contains(next)) continue;
                canReinherit = false;
                break;
            }
            if (canReinherit) {
                result = reinherit.getExcludeDependentCommand((Element)uml);
            }
        }
        return result;
    }

    protected ICommand setTarget(IEditCommandRequest trigger, UMLRTTransition transition, UMLRTVertex newTarget) {
        return UMLRTCommandUtils.set(trigger, (EObject)transition.toUML(), (EStructuralFeature)UMLPackage.Literals.TRANSITION__TARGET, newTarget.toUML());
    }

    protected ICommand setSource(IEditCommandRequest trigger, UMLRTTransition transition, UMLRTVertex newSource) {
        return UMLRTCommandUtils.set(trigger, (EObject)transition.toUML(), (EStructuralFeature)UMLPackage.Literals.TRANSITION__SOURCE, newSource.toUML());
    }

    protected ICommand unsetTarget(IEditCommandRequest trigger, UMLRTTransition transition) {
        return UMLRTCommandUtils.unset(trigger, (EObject)transition.toUML(), (EStructuralFeature)UMLPackage.Literals.TRANSITION__TARGET);
    }

    protected ICommand unsetSource(IEditCommandRequest trigger, UMLRTTransition transition) {
        return UMLRTCommandUtils.unset(trigger, (EObject)transition.toUML(), (EStructuralFeature)UMLPackage.Literals.TRANSITION__SOURCE);
    }

    protected ICommand delete(IEditCommandRequest trigger, UMLRTTransition transition) {
        return UMLRTCommandUtils.destroy(trigger, (EObject)transition.toUML());
    }
}

