/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Either<T, U> {
    private static final Either<?, ?> EMPTY = new Either();
    private final T t;
    private final U u;

    private Either() {
        this.t = null;
        this.u = null;
    }

    private Either(T t, U u) {
        this.t = t;
        this.u = u;
    }

    public static <T, U> Either<T, U> empty() {
        return EMPTY;
    }

    public static <T, U> Either<T, U> of(T t) {
        return new Either<T, Object>(Objects.requireNonNull(t), null);
    }

    public static <T, U> Either<T, U> ofAlternate(U u) {
        return new Either<Object, U>(null, Objects.requireNonNull(u));
    }

    public static <T, U> Either<T, U> or(T t, U u) {
        if (t != null && u != null) {
            throw new IllegalArgumentException("both values cannot be null");
        }
        return t != null ? Either.of(t) : (u != null ? Either.ofAlternate(u) : Either.empty());
    }

    public static <T, U> Either<T, U> cast(Object object, Class<T> type, Class<U> alternateType) {
        if (Objects.requireNonNull(type).isInstance(object) && Objects.requireNonNull(alternateType).isInstance(object)) {
            throw new IllegalArgumentException("object is an instance of both types");
        }
        return type.isInstance(object) ? Either.of(type.cast(object)) : (alternateType.isInstance(object) ? Either.ofAlternate(alternateType.cast(object)) : Either.empty());
    }

    public static <T, U> Either<T, U> or(T t, Supplier<? extends U> u) {
        if (t != null) {
            return Either.of(t);
        }
        U u_ = Objects.requireNonNull(u).get();
        return u_ != null ? Either.ofAlternate(u_) : Either.empty();
    }

    public static <T, U> Either<T, U> of(Optional<T> t, Optional<U> u) {
        if (Objects.requireNonNull(t).isPresent() && Objects.requireNonNull(u).isPresent()) {
            throw new IllegalArgumentException("both optionals cannot be present");
        }
        return t.isPresent() ? Either.of(t.get()) : (u.isPresent() ? Either.ofAlternate(u.get()) : Either.empty());
    }

    public static <T, U> Either<T, U> or(Optional<T> t, Supplier<Optional<U>> u) {
        if (t.isPresent()) {
            return Either.of(t.get());
        }
        Optional<U> u_ = Objects.requireNonNull(u).get();
        return u_.isPresent() ? Either.ofAlternate(u_.get()) : Either.empty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Either)) {
            return false;
        }
        Either other = (Either)obj;
        return Objects.equals(this.t, other.t) && Objects.equals(this.u, other.u);
    }

    public int hashCode() {
        return Objects.hash(this.t, this.u);
    }

    public boolean isPresent() {
        return this.t != null;
    }

    public boolean isAlternate() {
        return this.u != null;
    }

    public boolean isEither() {
        return this.t != null || this.u != null;
    }

    public T get() {
        if (this.t == null) {
            throw new NoSuchElementException();
        }
        return this.t;
    }

    public U getAlternate() {
        if (this.u == null) {
            throw new NoSuchElementException();
        }
        return this.u;
    }

    public Object getEither() {
        if (this.t != null) {
            return this.t;
        }
        if (this.u != null) {
            return this.u;
        }
        throw new NoSuchElementException();
    }

    public Object orElse(Object other) {
        return this.isEither() ? this.getEither() : other;
    }

    public Object orElseGet(Supplier<?> other) {
        return this.isEither() ? this.getEither() : Objects.requireNonNull(other).get();
    }

    public <X extends Throwable> Object orElseThrow(Supplier<? extends X> exception) throws X {
        if (this.isEither()) {
            return this.getEither();
        }
        throw (Throwable)Objects.requireNonNull(exception).get();
    }

    public <S> S getEither(Class<S> commonSupertype) {
        return commonSupertype.cast(this.getEither());
    }

    public <S> S orElse(Class<S> commonSupertype, S other) {
        return this.isEither() ? this.getEither(commonSupertype) : other;
    }

    public <S> S orElseGet(Class<S> commonSupertype, Supplier<? extends S> other) {
        return this.isEither() ? this.getEither(commonSupertype) : Objects.requireNonNull(other).get();
    }

    public <S, X extends Throwable> S orElseThrow(Class<S> commonSupertype, Supplier<? extends X> exception) throws X {
        if (this.isEither()) {
            return this.getEither(commonSupertype);
        }
        throw (Throwable)Objects.requireNonNull(exception).get();
    }

    public Either<T, U> ifPresent(Consumer<? super T> consumer) {
        if (this.t != null) {
            consumer.accept(this.t);
        }
        return this;
    }

    public Either<T, U> ifAlternate(Consumer<? super U> consumer) {
        if (this.u != null) {
            consumer.accept(this.u);
        }
        return this;
    }

    public Either<T, U> ifAbsent(Runnable action) {
        if (this.t == null && this.u == null) {
            action.run();
        }
        return this;
    }

    public Either<T, U> ifPresent(Consumer<? super T> consumer, Consumer<? super U> alternate) {
        if (this.t != null) {
            consumer.accept(this.t);
        } else if (this.u != null) {
            alternate.accept(this.u);
        }
        return this;
    }

    public <S> Optional<S> ifEither(Class<S> commonSupertype, Consumer<? super S> consumer) {
        if (this.isEither()) {
            S either = this.getEither(commonSupertype);
            consumer.accept(either);
            return Optional.of(either);
        }
        return Optional.empty();
    }

    public Either<T, U> accept(Consumer<? super T> consumer, Consumer<? super U> alternate, Runnable absent) {
        if (this.t != null) {
            consumer.accept(this.t);
        } else if (this.u != null) {
            alternate.accept(this.u);
        } else {
            absent.run();
        }
        return this;
    }

    public <F> Either<F, U> map(Function<? super T, F> mapper) {
        return this.t != null ? Either.of(mapper.apply(this.t)) : this;
    }

    public <G> Either<T, G> mapAlternate(Function<? super U, G> mapper) {
        return this.u != null ? Either.ofAlternate(mapper.apply(this.u)) : this;
    }

    public <S, R> Optional<R> mapEither(Class<S> commonSupertype, Function<? super S, ? extends R> mapping) {
        if (this.isEither()) {
            S either = this.getEither(commonSupertype);
            return Optional.ofNullable(mapping.apply(either));
        }
        return Optional.empty();
    }

    public <S, R> Optional<R> flatMapEither(Class<S> commonSupertype, Function<? super S, Optional<R>> mapping) {
        if (this.isEither()) {
            S either = this.getEither(commonSupertype);
            return Objects.requireNonNull(mapping.apply(either));
        }
        return Optional.empty();
    }

    public <F, G> Either<F, G> map(Function<? super T, F> ifPresent, Function<? super U, G> ifAlternate) {
        return this.t != null ? Either.of(ifPresent.apply(this.t)) : (this.u != null ? Either.ofAlternate(ifAlternate.apply(this.u)) : Either.empty());
    }

    public <F, G> Either<F, G> flatMap(Function<? super T, Optional<F>> ifPresent, Function<? super U, Optional<G>> ifAlternate) {
        if (this.t != null) {
            Optional<F> result = ifPresent.apply(this.t);
            return result.map((? super T f) -> Either.of(f)).orElse(Either.empty());
        }
        if (this.u != null) {
            Optional<G> result = ifAlternate.apply(this.u);
            return result.map((? super T g) -> Either.ofAlternate(g)).orElse(Either.empty());
        }
        return Either.empty();
    }

    public <R> Optional<R> map(BiFunction<? super T, ? super U, R> mapper) {
        return this.t != null || this.u != null ? Optional.ofNullable(mapper.apply(this.t, this.u)) : Optional.empty();
    }

    public <R> Optional<R> flatMap(BiFunction<? super T, ? super U, Optional<R>> mapper) {
        return this.t != null || this.u != null ? Objects.requireNonNull(mapper.apply(this.t, this.u)) : Optional.empty();
    }

    public Either<T, U> filter(Predicate<? super T> filter) {
        return this.t != null && filter.test(this.t) ? this : Either.empty();
    }

    public Either<T, U> filterAlternate(Predicate<? super U> filter) {
        return this.u != null && filter.test(this.u) ? this : Either.empty();
    }

    public Either<T, U> filter(BiPredicate<? super T, ? super U> filter) {
        return (this.t != null || this.u != null) && filter.test(this.t, this.u) ? this : Either.empty();
    }

    public String toString() {
        return this.t != null || this.u != null ? String.format("Either[%s][%s]", this.t == null ? "" : this.t, this.u == null ? "" : this.u) : "Either.empty";
    }
}

