/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class MultiplicityElementAdapter
extends AdapterImpl {
    public void setTarget(Notifier newTarget) {
        if (newTarget == null || this.getTargetType().isInstance(newTarget)) {
            super.setTarget(newTarget);
            if (newTarget instanceof MultiplicityElement) {
                this.handleNewTarget();
            }
        }
    }

    void handleNewTarget() {
        MultiplicityElement newTarget = this.getTarget();
        if (newTarget.getLowerValue() != null) {
            this.adapt((Notifier)newTarget.getLowerValue());
        }
        if (newTarget.getUpperValue() != null) {
            this.adapt((Notifier)newTarget.getUpperValue());
        }
    }

    Class<? extends MultiplicityElement> getTargetType() {
        return MultiplicityElement.class;
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget == this.getTarget()) {
            this.handleOldTarget();
        }
        super.unsetTarget(oldTarget);
    }

    void handleOldTarget() {
        MultiplicityElement oldTarget = this.getTarget();
        if (oldTarget.getLowerValue() != null) {
            this.unadapt((Notifier)oldTarget.getLowerValue());
        }
        if (oldTarget.getUpperValue() != null) {
            this.unadapt((Notifier)oldTarget.getUpperValue());
        }
    }

    public MultiplicityElement getTarget() {
        return (MultiplicityElement)super.getTarget();
    }

    public void adapt(Notifier notifier) {
        if (!notifier.eAdapters().contains((Object)this)) {
            notifier.eAdapters().add((Object)this);
        }
    }

    public void unadapt(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    public void notifyChanged(Notification notification) {
        block0 : switch (notification.getEventType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (notification.getFeature() != UMLPackage.Literals.OPAQUE_EXPRESSION__BODY) break;
            }
            case 1: 
            case 2: {
                if (notification.isTouch()) break;
            }
            case 9: {
                MultiplicityElement target = this.getTarget();
                Object notifier = notification.getNotifier();
                Object feature = notification.getFeature();
                if (notifier == target) {
                    switch (notification.getFeatureID(MultiplicityElement.class)) {
                        case 7: 
                        case 9: {
                            ValueSpecification oldValue = (ValueSpecification)notification.getOldValue();
                            ValueSpecification newValue = (ValueSpecification)notification.getNewValue();
                            this.adaptChange((Notifier)oldValue, (Notifier)newValue);
                            if (feature == UMLPackage.Literals.MULTIPLICITY_ELEMENT__LOWER_VALUE) {
                                this.handleLowerValueReplaced(oldValue, newValue, notification);
                                break block0;
                            }
                            this.handleUpperValueReplaced(oldValue, newValue, notification);
                            break block0;
                        }
                    }
                    this.handleOtherTargetNotification(notification);
                    break;
                }
                if (this.handleDetailNotification(notifier, feature, notification)) break;
                this.unadapt((Notifier)notifier);
            }
        }
    }

    final void adaptChange(Notifier oldNotifier, Notifier newNotifier) {
        if (oldNotifier != null) {
            this.unadapt(oldNotifier);
        }
        if (newNotifier != null) {
            this.adapt(newNotifier);
        }
    }

    void handleOtherTargetNotification(Notification notification) {
    }

    boolean handleDetailNotification(Object notifier, Object feature, Notification notification) {
        boolean result = false;
        if (notifier instanceof ValueSpecification && this.getTarget() != null && ((ValueSpecification)notifier).eContainer() == this.getTarget()) {
            result = true;
            if (feature instanceof EAttribute) {
                ValueSpecification value = (ValueSpecification)notifier;
                if (value == this.getTarget().getLowerValue()) {
                    this.handleLowerValueChanged(value, (EAttribute)feature, notification);
                } else if (value == this.getTarget().getUpperValue()) {
                    this.handleUpperValueChanged(value, (EAttribute)feature, notification);
                }
            }
        }
        return result;
    }

    protected void handleLowerValueReplaced(ValueSpecification oldLowerValue, ValueSpecification newLowerValue, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    protected void handleUpperValueReplaced(ValueSpecification oldUpperValue, ValueSpecification newUpperValue, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    protected void handleMultiplicityChanged(Notification notification) {
    }

    protected void handleLowerValueChanged(ValueSpecification lowerValue, EAttribute feature, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    protected void handleUpperValueChanged(ValueSpecification upperValue, EAttribute feature, Notification notification) {
        this.handleMultiplicityChanged(notification);
    }

    public static class ForProperty
    extends MultiplicityElementAdapter {
        Class<? extends Property> getTargetType() {
            return Property.class;
        }

        public Property getTarget() {
            return (Property)super.getTarget();
        }

        @Override
        void handleNewTarget() {
            super.handleNewTarget();
            Property newTarget = this.getTarget();
            if (newTarget.getType() != null) {
                this.adapt((Notifier)newTarget.getType());
            }
        }

        @Override
        void handleOldTarget() {
            Property oldTarget = this.getTarget();
            if (oldTarget.getType() != null) {
                this.unadapt((Notifier)oldTarget.getType());
            }
            super.handleOldTarget();
        }

        @Override
        void handleOtherTargetNotification(Notification notification) {
            switch (notification.getFeatureID(Property.class)) {
                case 15: {
                    Type oldType = (Type)notification.getOldValue();
                    Type newType = (Type)notification.getNewValue();
                    this.adaptChange((Notifier)oldType, (Notifier)newType);
                    this.handleTypeReplaced(oldType, newType, notification);
                }
            }
        }

        @Override
        boolean handleDetailNotification(Object notifier, Object feature, Notification notification) {
            boolean result = false;
            if (notifier instanceof Type && feature instanceof EStructuralFeature && this.getTarget().getType() == notifier) {
                result = true;
                this.handleTypeChanged((Type)notifier, (EStructuralFeature)feature, notification);
            }
            return result || super.handleDetailNotification(notifier, feature, notification);
        }

        protected void handleTypeReplaced(Type oldType, Type newType, Notification notification) {
            this.handleTypeChanged(notification);
        }

        protected void handleTypeChanged(Notification notification) {
            this.handleMultiplicityChanged(notification);
        }

        protected void handleTypeChanged(Type type, EStructuralFeature feature, Notification notification) {
            this.handleTypeChanged(notification);
        }
    }
}

