/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.tools.util.CoreExecutors;
import org.eclipse.papyrusrt.umlrt.core.Activator;

public class PostTransactionExecutor
implements Executor {
    private static final LoadingCache<TransactionalEditingDomain, Executor> executors = CacheBuilder.newBuilder().weakKeys().weakValues().build(CacheLoader.from(domain -> new PostTransactionExecutor((TransactionalEditingDomain)domain, (Executor)CoreExecutors.getUIExecutorService())));
    private final ConcurrentLinkedQueue<Runnable> pendingTasks = new ConcurrentLinkedQueue();
    private final Executor fallback;
    private final AtomicReference<Transaction> activeTransaction;

    private PostTransactionExecutor(TransactionalEditingDomain domain, Executor fallback) {
        this.fallback = fallback;
        InternalTransaction active = ((InternalTransactionalEditingDomain)domain).getActiveTransaction();
        this.activeTransaction = new AtomicReference<InternalTransaction>(active == null ? null : active.getRoot());
        final TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.Lifecycle.class);
        lifecycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)new TransactionalEditingDomainListenerImpl(){

            public void transactionStarted(TransactionalEditingDomainEvent event) {
                PostTransactionExecutor.this.activeTransaction.compareAndSet(null, event.getTransaction());
            }

            public void transactionClosed(TransactionalEditingDomainEvent event) {
                if (PostTransactionExecutor.this.activeTransaction.compareAndSet(event.getTransaction(), null)) {
                    PostTransactionExecutor.this.executePending();
                }
            }

            public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
                lifecycle.removeTransactionalEditingDomainListener((TransactionalEditingDomainListener)this);
                PostTransactionExecutor.this.executePending();
            }
        });
    }

    public static Executor getInstance(TransactionalEditingDomain domain) {
        return (Executor)executors.getUnchecked((Object)domain);
    }

    public static Executor getInstance(EObject object) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)object);
        return domain == null ? CoreExecutors.getUIExecutorService() : PostTransactionExecutor.getInstance(domain);
    }

    @Override
    public void execute(Runnable command) {
        Transaction active = this.activeTransaction.get();
        if (active == null) {
            this.fallback.execute(command);
        } else {
            this.pendingTasks.add(command);
        }
    }

    private void executePending() {
        Runnable task = this.pendingTasks.poll();
        while (task != null) {
            try {
                task.run();
            }
            catch (Exception e) {
                Activator.log.error("Uncaught exception in post-commit runnable", (Throwable)e);
            }
            task = this.pendingTasks.poll();
        }
    }
}

