/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrusrt.umlrt.core.types.ElementTypeUtils;
import org.eclipse.papyrusrt.umlrt.core.types.UMLRTElementTypesEnumerator;
import org.eclipse.papyrusrt.umlrt.core.utils.UMLRTProfileUtils;
import org.eclipse.papyrusrt.umlrt.profile.statemachine.UMLRTStateMachines.UMLRTStateMachinesPackage;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class RegionUtils {
    public static boolean isRTRegion(Region region) {
        return ElementTypeUtils.matches((EObject)region, "org.eclipse.papyrusrt.umlrt.core.RTRegion");
    }

    public static ICommand getConfigureAsRTRegionCommand(Region region) {
        return ElementTypeUtils.getConfigureAsCommand((IElementType)UMLRTElementTypesEnumerator.RT_REGION, (EObject)region);
    }

    public static Region applyStereotype(Region region) {
        return UMLRTProfileUtils.ensureStereotype(region, UMLRTStateMachinesPackage.Literals.RT_REGION);
    }

    public static List<Pseudostate> getInitialPseudoStates(Region region) {
        ArrayList<Pseudostate> pseudoStates = new ArrayList<Pseudostate>();
        for (Vertex vertex : region.getSubvertices()) {
            if (!RegionUtils.isInitialPseudoState(vertex)) continue;
            pseudoStates.add((Pseudostate)vertex);
        }
        return pseudoStates;
    }

    public static List<State> getStates(Region region) {
        ArrayList<State> states = new ArrayList<State>();
        for (Vertex vertex : region.getSubvertices()) {
            if (!(vertex instanceof State)) continue;
            states.add((State)vertex);
        }
        return states;
    }

    public static boolean isInitialPseudoState(Vertex vertex) {
        Pseudostate ps;
        return vertex instanceof Pseudostate && (ps = (Pseudostate)vertex).getKind() == PseudostateKind.INITIAL_LITERAL;
    }

    public static boolean shouldApproveMoveRequest(MoveRequest request) {
        Region targetRegion = null;
        if (!(request.getTargetContainer() instanceof Region)) {
            return false;
        }
        targetRegion = (Region)request.getTargetContainer();
        for (Object o : request.getElementsToMove().keySet()) {
            if (!(o instanceof EObject) || ((EObject)o).eContainer() != null) {
                return false;
            }
            if (!(o instanceof Transition)) continue;
            Transition transition = (Transition)o;
            if (transition.getSource() == null || transition.getSource().eContainer() != null) {
                return false;
            }
            if (transition.getTarget() != null && transition.getTarget().eContainer() == null) continue;
            return false;
        }
        List pseudostatesToMove = request.getElementsToMove().keySet().stream().filter(Pseudostate.class::isInstance).map(Pseudostate.class::cast).collect(Collectors.toList());
        List pseudostatesInRegion = targetRegion.getSubvertices().stream().filter(Pseudostate.class::isInstance).map(Pseudostate.class::cast).collect(Collectors.toList());
        long nuInitialStatesToMove = pseudostatesToMove.stream().filter(p -> PseudostateKind.INITIAL_LITERAL == p.getKind()).count();
        if (nuInitialStatesToMove > 1L || nuInitialStatesToMove == 1L && pseudostatesInRegion.stream().anyMatch(p -> PseudostateKind.INITIAL_LITERAL == p.getKind())) {
            return false;
        }
        List deepHistoryToMove = pseudostatesToMove.stream().filter(p -> PseudostateKind.DEEP_HISTORY_LITERAL == p.getKind()).collect(Collectors.toList());
        if (deepHistoryToMove.size() > 1) {
            return false;
        }
        if (deepHistoryToMove.size() == 1) {
            if (targetRegion.getState() == null) {
                return false;
            }
            if (pseudostatesInRegion.stream().anyMatch(p -> p.getKind() == PseudostateKind.DEEP_HISTORY_LITERAL)) {
                return false;
            }
        }
        return !pseudostatesToMove.stream().anyMatch(p -> p.getKind() == PseudostateKind.ENTRY_POINT_LITERAL || p.getKind() == PseudostateKind.EXIT_POINT_LITERAL);
    }
}

