/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.core.utils;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrusrt.umlrt.core.utils.StateUtils;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTGuard;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTransition;
import org.eclipse.papyrusrt.umlrt.uml.UMLRTTrigger;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Trigger;

public final class TransitionUtils {
    private TransitionUtils() {
    }

    public static TransitionKind getTransitionKind(Transition transition, EObject source, EObject target) {
        EObject targetState;
        EObject sourceState = TransitionUtils.getImplicitState(source);
        boolean isLoop = sourceState == (targetState = TransitionUtils.getImplicitState(target));
        TransitionKind expectedKind = TransitionKind.EXTERNAL_LITERAL;
        if (StateUtils.isCompositeState(sourceState)) {
            if (!isLoop && Stream.iterate(targetState, EObject::eContainer).filter(e -> e == sourceState || e.eContainer() == null).findFirst().get() == sourceState) {
                expectedKind = TransitionKind.LOCAL_LITERAL;
            }
            if (isLoop && Stream.iterate(transition, EObject::eContainer).filter(e -> e == sourceState || e.eContainer() == null).findFirst().get() == sourceState) {
                expectedKind = transition != null && TransitionKind.INTERNAL_LITERAL.equals((Object)transition.getKind()) ? TransitionKind.INTERNAL_LITERAL : TransitionKind.LOCAL_LITERAL;
            }
        }
        return expectedKind;
    }

    public static TransitionKind getTransitionKind(Region transitionContainer, EObject source, EObject target) {
        EObject targetState;
        EObject sourceState = TransitionUtils.getImplicitState(source);
        boolean isLoop = sourceState == (targetState = TransitionUtils.getImplicitState(target));
        TransitionKind expectedKind = TransitionKind.EXTERNAL_LITERAL;
        if (sourceState instanceof State && ((State)sourceState).isComposite()) {
            if (!isLoop && Stream.iterate(targetState, EObject::eContainer).filter(e -> e == sourceState || e.eContainer() == null).findFirst().get() == sourceState) {
                expectedKind = TransitionKind.LOCAL_LITERAL;
            }
            if (isLoop && transitionContainer != null && Stream.iterate(transitionContainer, EObject::eContainer).filter(e -> e == sourceState || e.eContainer() == null).findFirst().get() == sourceState) {
                expectedKind = TransitionKind.LOCAL_LITERAL;
            }
        }
        return expectedKind;
    }

    public static EObject getImplicitState(EObject vertex) {
        PseudostateKind kind;
        if (vertex instanceof Pseudostate && (PseudostateKind.ENTRY_POINT_LITERAL.equals((Object)(kind = ((Pseudostate)vertex).getKind())) || PseudostateKind.EXIT_POINT_LITERAL.equals((Object)kind))) {
            return vertex.eContainer();
        }
        return vertex;
    }

    public static boolean isInternalTransition(EObject object) {
        return object instanceof Transition && TransitionKind.INTERNAL_LITERAL == ((Transition)object).getKind();
    }

    public static boolean hasNameAndNoTriggers(Transition transition) {
        UMLRTTransition rt = UMLRTTransition.getInstance((Transition)transition);
        return rt != null && !Strings.isNullOrEmpty((String)rt.getName()) && rt.getTriggers().isEmpty();
    }

    public static List<Constraint> getGuards(Transition transition) {
        UMLRTTransition facade = UMLRTTransition.getInstance((Transition)transition);
        return facade == null ? Collections.emptyList() : Stream.concat(Stream.of(facade.getGuard()), facade.getTriggers().stream().map(UMLRTTrigger::getGuard)).filter(Objects::nonNull).map(UMLRTGuard::toUML).collect(Collectors.toList());
    }

    public static Constraint getTriggerGuard(Trigger trigger) {
        return Optional.ofNullable(UMLRTTrigger.getInstance((Trigger)trigger)).map(UMLRTTrigger::getGuard).map(UMLRTGuard::toUML).orElse(null);
    }
}

