/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.system.profile.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrusrt.umlrt.profile.UMLRealTime.Protocol;
import org.eclipse.papyrusrt.umlrt.system.profile.systemelements.BaseProtocol;
import org.eclipse.papyrusrt.umlrt.system.profile.systemelements.SystemClass;
import org.eclipse.papyrusrt.umlrt.system.profile.systemelements.SystemProtocol;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class SystemElementsUtils {
    public static Set<Collaboration> getSystemProtocols(Resource resource) {
        if (resource != null && resource.getContents().size() > 0) {
            HashSet<Collaboration> result = new HashSet<Collaboration>();
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                Collaboration collaboration;
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Collaboration) || !SystemElementsUtils.isProtocol(collaboration = (Collaboration)eObject) || !SystemElementsUtils.isSystemProtocol(collaboration)) continue;
                result.add(collaboration);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static Collaboration getBaseProtocol(Resource resource) {
        if (resource != null && resource.getContents().size() > 0) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                Collaboration collaboration;
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Collaboration) || !SystemElementsUtils.isProtocol(collaboration = (Collaboration)eObject) || !SystemElementsUtils.isBaseProtocol((Collaboration)eObject)) continue;
                return (Collaboration)eObject;
            }
        }
        return null;
    }

    public static Set<Class> getSystemClasss(Resource resource) {
        if (resource != null && resource.getContents().size() > 0) {
            HashSet<Class> result = new HashSet<Class>();
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (!(eObject instanceof Class) || !SystemElementsUtils.isSystemClass((Class)eObject)) continue;
                result.add((Class)eObject);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static boolean isProtocol(Collaboration element) {
        return UMLUtil.getStereotypeApplication((Element)element, Protocol.class) != null;
    }

    public static boolean isSystemProtocol(Collaboration element) {
        return UMLUtil.getStereotypeApplication((Element)element, SystemProtocol.class) != null;
    }

    public static boolean isBaseProtocol(Collaboration element) {
        return UMLUtil.getStereotypeApplication((Element)element, BaseProtocol.class) != null;
    }

    public static boolean isSystemClass(Class element) {
        return UMLUtil.getStereotypeApplication((Element)element, SystemClass.class) != null;
    }
}

