/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.databinding;

import java.util.function.Predicate;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.papyrus.infra.tools.databinding.IDelegatingObservable;
import org.eclipse.papyrusrt.umlrt.tooling.ui.databinding.FilteredObservableList;

public interface IFilteredObservableList<E> {
    public boolean addFilter(Predicate<? super E> var1);

    public boolean removeFilter(Predicate<? super E> var1);

    public static <E> IFilteredObservableList<E> getFilteredList(IObservableList<E> list) {
        IFilteredObservableList<E> result = null;
        if (list instanceof IFilteredObservableList) {
            IFilteredObservableList<E> filtered;
            result = filtered = (IFilteredObservableList<E>)list;
        } else if (list instanceof IDelegatingObservable) {
            IObservableList delegate = (IObservableList)((IDelegatingObservable)list).getDelegate();
            result = IFilteredObservableList.getFilteredList(delegate);
        }
        return result;
    }

    public static <E> IObservableList<E> wrap(IObservableList<E> list) {
        return list instanceof IFilteredObservableList ? list : (list instanceof IObserving ? new FilteredObservableList.Observing<E>(list) : new FilteredObservableList<E>(list));
    }
}

