/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrusrt.umlrt.tooling.ui.editors;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.providers.TreeCollectionContentProvider;
import org.eclipse.papyrusrt.umlrt.tooling.ui.editors.AbstractInheritableMultipleReferenceEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class InheritableMultipleReferenceEditor
extends AbstractInheritableMultipleReferenceEditor {
    private final int style;
    private IBaseLabelProvider labelProvider;
    protected TreeViewer treeViewer;
    protected Tree tree;

    public InheritableMultipleReferenceEditor(Composite parent, int style) {
        this(parent, style, false, false, null);
    }

    public InheritableMultipleReferenceEditor(Composite parent, int style, String label) {
        this(parent, style, false, false, label);
    }

    public InheritableMultipleReferenceEditor(Composite parent, int style, boolean ordered, boolean unique, String label) {
        super(parent, ordered, unique, label);
        this.style = style;
        this.createContents();
    }

    protected Control createContents(Composite parent) {
        this.tree = new Tree(parent, this.style | 2 | 0x200 | 0x100 | 0x800 | 0x10000);
        this.tree.addSelectionListener((SelectionListener)this);
        this.treeViewer = new TreeViewer(this.tree);
        this.treeViewer.setContentProvider((IContentProvider)TreeCollectionContentProvider.instance);
        IBaseLabelProvider labels = this.getLabelProvider();
        if (labels != null) {
            this.treeViewer.setLabelProvider(labels);
        }
        return this.tree;
    }

    protected ISelectionProvider getSelectionProvider(Control contentControl) {
        return this.treeViewer;
    }

    protected void setInput(IObservableList modelProperty) {
        this.treeViewer.setInput((Object)modelProperty);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        if (this.treeViewer != null) {
            this.treeViewer.setLabelProvider(labelProvider);
        }
    }

    public IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public void dispose() {
        if (this.tree != null) {
            this.tree.removeSelectionListener((SelectionListener)this);
        }
        super.dispose();
    }

    public void refreshValue() {
        this.treeViewer.refresh();
    }
}

